import { Form, Input } from "antd";

import { getManagerDependingVariables } from "@devowl-wp/cookie-consent-web-client";

import { useFormService } from "../../../../../contexts/formService.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../../common/learnMoreTag.js";
import { Notices } from "../../../../common/notices.js";

import type { FormServiceValueProps } from "../../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldHandlingTagManagerEventName: FC = () => {
    const { __ } = useI18n();
    const { setCookiesViaManager, createdTagManagers, isGcm, template } = useFormService();

    const { managerLabel, features, expectedManagerPresetId } = getManagerDependingVariables(setCookiesViaManager, {
        isGcm,
        presetId: template?.identifier,
    });

    return (
        features.events && (
            <Form.Item<FormServiceValueProps> label={__("Event names for %s", managerLabel)} required>
                <Form.Item<FormServiceValueProps> name="tagManagerOptInEventName" noStyle>
                    <Input addonBefore={__("Opt-in")} style={{ maxWidth: 400, marginRight: 10, marginBottom: 5 }} />
                </Form.Item>
                <Form.Item<FormServiceValueProps> name="tagManagerOptOutEventName" noStyle>
                    <Input addonBefore={__("Opt-out")} style={{ maxWidth: 400, marginRight: 10, marginBottom: 5 }} />
                </Form.Item>
                <p className="description">
                    <LearnMoreTag
                        url={__(
                            "https://devowl.io/knowledge-base/real-cookie-banner-with-google-tag-manager-or-matomo-tag-manager/",
                        )}
                    />
                </p>
                <Form.Item<FormServiceValueProps>
                    noStyle
                    shouldUpdate={(prevValues, curValues) =>
                        prevValues.tagManagerOptInEventName !== curValues.tagManagerOptInEventName ||
                        prevValues.tagManagerOptOutEventName !== curValues.tagManagerOptOutEventName
                    }
                >
                    {({ getFieldValue }) => {
                        const inEventName = getFieldValue("tagManagerOptInEventName") as string;
                        const outEventName = getFieldValue("tagManagerOptOutEventName") as string;

                        return (
                            (inEventName.length > 0 || outEventName.length > 0) &&
                            !!managerLabel &&
                            !createdTagManagers[expectedManagerPresetId].length && (
                                <Notices
                                    notices={[
                                        {
                                            message: __(
                                                "You have not yet defined a %s service. To use event names, you must create a %s service.",
                                                managerLabel,
                                                managerLabel,
                                            ),
                                            severity: "warning",
                                        },
                                    ]}
                                />
                            )
                        );
                    }}
                </Form.Item>
            </Form.Item>
        )
    );
};

export { FormServiceFieldHandlingTagManagerEventName };
