import { Form } from "antd";

import type { VisualServiceTechnicalDefinition } from "@devowl-wp/react-cookie-banner";

import { useFormService } from "../../../../../contexts/formService.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { FormServiceFieldGeneralIsEmbeddingOnlyExternalResources } from "../general/isEmbeddingOnlyExternalResources.js";
import { FormServiceFieldTechnicalDefinitionsTable } from "./definitions/table.js";
import { FormHeadline } from "../../../headline.js";
import { FormServiceLayout } from "../../../layout.js";
import { FormServiceFieldHandlingDeleteTechnicalDefinitionsAfterOptOut } from "../handling/deleteTechnicalDefinitionsAfterOptOut.js";

import type { FC } from "react";

const TECHNICAL_DEFINITION_DEFAULTS: VisualServiceTechnicalDefinition = {
    type: "http",
    name: "",
    host: "",
    duration: undefined,
    durationUnit: "y",
    isSessionDuration: false,
    purpose: "",
};

const FormServiceFieldTechnicalCompose: FC = () => {
    const { __, _i } = useI18n();
    const { essentialGroupId } = useFormService();

    return (
        <Form.Item noStyle shouldUpdate={(prevValues, nextValues) => prevValues.group !== nextValues.group}>
            {({ getFieldValue }) => {
                const isOptOutOptionUsable = getFieldValue("group") !== essentialGroupId;
                return (
                    <div>
                        <FormHeadline
                            offset={FormServiceLayout.labelCol.span}
                            description={_i(
                                __(
                                    "For each service you use, you should specify all cookies that are used by it. You can find this out in the developer console of your browser. Please note that there are several types of cookies and according to {{aEprivacy}}ePrivacy Directive (Directive 2009/136/EC) Recital 66{{/aEprivacy}} you have to inform your visitors not only about (HTTP) cookies, but also about cookie-like information.",
                                ),
                                {
                                    aEprivacy: (
                                        <a
                                            href={__("https://devowl.io/go/eu-directive-2009-136-ec")}
                                            target="_blank"
                                            rel="noreferrer"
                                        />
                                    ),
                                },
                            )}
                        >
                            {__("Technical cookie information")}
                        </FormHeadline>
                        <FormServiceFieldGeneralIsEmbeddingOnlyExternalResources />
                        {isOptOutOptionUsable && <FormServiceFieldHandlingDeleteTechnicalDefinitionsAfterOptOut />}
                        <FormServiceFieldTechnicalDefinitionsTable />
                    </div>
                );
            }}
        </Form.Item>
    );
};

export { FormServiceFieldTechnicalCompose, TECHNICAL_DEFINITION_DEFAULTS };
