import { Form, Input } from "antd";

import { useI18n } from "../../../../../../../contexts/i18n.js";
import { Notices } from "../../../../../../common/notices.js";
import { FormServiceFieldTechnicalDefinitionsLayout } from "../table.js";

import type { FormServiceValueProps } from "../../../../../../../types/formService.js";
import type { FormListFieldData } from "../table.js";
import type { FC } from "react";

const FormServiceFieldTechnicalDefinitionsCookieName: FC<{ field: FormListFieldData; readOnly?: boolean }> = ({
    field,
    readOnly,
}) => {
    const { __, _i } = useI18n();

    return (
        <>
            <Form.Item<FormServiceValueProps["technicalDefinitions"]>
                {...FormServiceFieldTechnicalDefinitionsLayout}
                name={[field.name, "name"]}
                rules={[
                    {
                        required: true,
                        message: __("Please provide a technical cookie name!"),
                    },
                ]}
            >
                <Input disabled={readOnly} />
            </Form.Item>
            <Form.Item<FormServiceValueProps>
                noStyle
                shouldUpdate={(prevValues, nextValues) =>
                    prevValues.technicalDefinitions[field.name]?.name !==
                    nextValues.technicalDefinitions[field.name]?.name
                }
            >
                {({ getFieldValue }) => {
                    const cookieName = getFieldValue(["technicalDefinitions", field.name, "name"]) as string;
                    const notSupportedCookieNamePlaceholders: Array<RegExp | [RegExp, any]> = [
                        /\[/gm,
                        [/([{]+)/gm, (match: string) => match.length === 1],
                        /\(/gm,
                    ];

                    return (
                        notSupportedCookieNamePlaceholders.filter((r) =>
                            Array.isArray(r)
                                ? r[0].test(cookieName) && cookieName.match(r[0]).filter(r[1]).length > 0
                                : r.test(cookieName),
                        ).length > 0 && (
                            <Notices
                                notices={[
                                    {
                                        message: _i(
                                            __(
                                                "Are you sure this is the name of the cookie? It seems like you are using a placeholder that is not supported. Please use an asterisk ({{code}}*{{/code}}) as a placeholder if the cookie name is dynamically composed.",
                                            ),
                                            {
                                                code: <code />,
                                            },
                                        ),
                                        severity: "warning",
                                    },
                                ]}
                            />
                        )
                    );
                }}
            </Form.Item>
        </>
    );
};

export { FormServiceFieldTechnicalDefinitionsCookieName };
