import { Form, Input } from "antd";

import type { FormServiceValueProps } from "../../../../../../../types/formService.js";
import type { FormListFieldData } from "../table.js";
import type { FC } from "react";

const FormServiceFieldTechnicalDefinitionsCookiePurpose: FC<{ field: FormListFieldData; readOnly?: boolean }> = ({
    field,
    readOnly,
}) => {
    return (
        <Form.Item<FormServiceValueProps["technicalDefinitions"]> noStyle name={[field.name, "purpose"]}>
            <Input.TextArea disabled={readOnly} rows={1} autoSize={{ maxRows: 3 }} />
        </Form.Item>
    );
};

export { FormServiceFieldTechnicalDefinitionsCookiePurpose };
