import { Form, Select } from "antd";

import { getCookieTypeLocalizationMap } from "@devowl-wp/react-cookie-banner";

import { useI18n } from "../../../../../../../contexts/i18n.js";

import type { FormServiceValueProps } from "../../../../../../../types/formService.js";
import type { FormListFieldData } from "../table.js";
import type { FC } from "react";

const FormServiceFieldTechnicalDefinitionsCookieType: FC<{ field: FormListFieldData; readOnly?: boolean }> = ({
    field,
    readOnly = false,
}) => {
    const { __ } = useI18n();
    const cookieTypeLocalized = getCookieTypeLocalizationMap();

    return (
        <Form.Item<FormServiceValueProps["technicalDefinitions"]>
            name={[field.name, "type"]}
            noStyle
            rules={[
                {
                    required: true,
                    message: __("Please provide a cookie type!"),
                },
            ]}
        >
            <Select disabled={readOnly}>
                {Object.keys(cookieTypeLocalized).map((key) => (
                    <Select.Option
                        key={key}
                        value={key}
                        style={{
                            display: key === "flash" ? "none" : undefined,
                        }}
                    >
                        {cookieTypeLocalized[key as keyof ReturnType<typeof getCookieTypeLocalizationMap>].name}
                    </Select.Option>
                ))}
            </Select>
        </Form.Item>
    );
};

export { FormServiceFieldTechnicalDefinitionsCookieType };
