import { Checkbox, Form } from "antd";

import { useFormService } from "../../../../contexts/formService.js";
import { useI18n } from "../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../common/learnMoreTag.js";

import type { FormServiceValueProps } from "../../../../types/formService.js";
import type { FC } from "react";

const FormServiceFieldTemplateCheck: FC = () => {
    const { __, _x } = useI18n();
    const { templateCheck, isTemplateUpdate } = useFormService();

    return (
        !!(templateCheck || isTemplateUpdate) && (
            <Form.Item<FormServiceValueProps>
                name="templateCheck"
                valuePropName="checked"
                required
                rules={[
                    {
                        type: "boolean",
                        required: true,
                        transform: (value) => value || undefined,
                        message: __("Please confirm that you have checked the contents of the service."),
                    },
                ]}
            >
                <Checkbox>
                    {_x(
                        "I have checked the information in the service template myself for correctness and completeness and have added missing information or corrected information that does not fit my use case. I am aware that the manufacturer of Real Cookie Banner cannot take any liability in this respect.",
                        "legal-text",
                    )}{" "}
                    <LearnMoreTag
                        url={__("https://devowl.io/knowledge-base/is-real-cookie-banner-legally-compliant/")}
                    />
                </Checkbox>
            </Form.Item>
        )
    );
};

export { FormServiceFieldTemplateCheck };
