import { Form } from "antd";
import { useRef } from "react";

import { FormFieldTemplateSuccessorDeletionCheck } from "../successorDeletionCheck.js";
import { FormUntranslatedTemplateNotice } from "../untranslatedTemplateNotice.js";
import { FormValueDifferFromTemplateNotice } from "../valueDifferFromTemplateNotice.js";
import { FormServiceFieldCreateContentBlocker } from "./fields/createContentBlocker.js";
import { FormServiceFieldGeneralCompose } from "./fields/general/compose.js";
import { FormServiceFieldHandlingCompose } from "./fields/handling/compose.js";
import { FormServiceFieldTechnicalCompose } from "./fields/technical/compose.js";
import { FormServiceFieldTemplateCheck } from "./fields/templateCheck.js";
import { useFormService } from "../../../contexts/formService.js";
import { useI18n } from "../../../contexts/i18n.js";
import { useFormInitiallyScrollToField } from "../../../hooks/useFormInitiallyScrollToField.js";
import {
    FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT,
    FormValueDifferFromTemplateResetButtonWithConfirm,
} from "../valueDifferFromTemplateResetButtonWithConfirm.js";

import type { FC } from "react";

const FormService: FC = () => {
    const { __ } = useI18n();

    const ref = useRef();
    const refResetTemplateButton = useRef<HTMLAnchorElement>();
    const { initiallyScrollToField, form } = useFormService();
    useFormInitiallyScrollToField(form, initiallyScrollToField);

    return (
        <div ref={ref}>
            <FormValueDifferFromTemplateNotice
                containerRef={ref}
                resetButton={refResetTemplateButton}
                resetButtonEvent={FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT}
                form="service"
            />
            <FormUntranslatedTemplateNotice form="service" />
            <FormServiceFieldGeneralCompose />
            <FormServiceFieldTechnicalCompose />
            <FormServiceFieldHandlingCompose />
            <FormServiceFieldCreateContentBlocker />
            <FormFieldTemplateSuccessorDeletionCheck type="service" />
            <Form.Item
                className="rcb-antd-form-sticky-submit"
                colon={false}
                labelAlign="left"
                label={<FormValueDifferFromTemplateResetButtonWithConfirm anchorRef={refResetTemplateButton} />}
            >
                <FormServiceFieldTemplateCheck />
                <div style={{ textAlign: "center", margin: "10px 0" }}>
                    <input type="submit" className="button button-primary" value={__("Save")} />
                </div>
            </Form.Item>
        </div>
    );
};

export { FormService };
