import { Form, Input } from "antd";

import { useI18n } from "../../../../contexts/i18n.js";

import type { FormServiceGroupValueProps } from "../../../../types/formServiceGroup.js";
import type { FC } from "react";

const FormServiceGroupFieldName: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormServiceGroupValueProps>
            label={__("Name")}
            name="name"
            required
            style={{ marginBottom: 12 }}
            rules={[{ required: true, message: __("Please enter a name!") }]}
        >
            <Input
                autoFocus
                onKeyDown={(e) =>
                    /**
                     * `rc-tabs` defines an `onKeyDown` event which causes issues with enter and spaces and avoids
                     * input fields in the tab to get filled correctly.
                     *
                     * @see https://git.io/JUZZO
                     */
                    e.stopPropagation()
                }
            />
        </Form.Item>
    );
};

export { FormServiceGroupFieldName };
