import { Form } from "antd";

import { FormServiceGroupFieldDescription } from "./fields/description.js";
import { FormServiceGroupFieldName } from "./fields/name.js";
import { useFormServiceGroup } from "../../../contexts/formServiceGroup.js";
import { useI18n } from "../../../contexts/i18n.js";
import { ListMultilingualLanguages } from "../../common/listMultilingualLanguages.js";

import type { FormServiceGroupValueProps } from "../../../types/formServiceGroup.js";
import type { FC } from "react";

const FormServiceGroup: FC = () => {
    const { __ } = useI18n();
    const { onCancel, recordId, languages, languageOnClick } = useFormServiceGroup();

    return (
        <div>
            {languages?.length > 0 && (
                <Form.Item<FormServiceGroupValueProps> label={__("Translations")} style={{ marginBottom: 12 }}>
                    <ListMultilingualLanguages recordId={recordId} languages={languages} onClick={languageOnClick} />
                </Form.Item>
            )}
            <FormServiceGroupFieldName />
            <FormServiceGroupFieldDescription />
            <Form.Item>
                {!!onCancel && (
                    <button
                        className="button"
                        onClick={(e) => {
                            e.preventDefault();
                            onCancel();
                        }}
                    >
                        {__("Cancel")}
                    </button>
                )}
                <input type="submit" className="button button-primary right" value={__("Save")} />
            </Form.Item>
        </div>
    );
};

export { FormServiceGroup };
