import { Form, Input } from "antd";

import { useI18n } from "../../../contexts/i18n.js";

import type { FC } from "react";

const FormSettingsAffiliateTabContent: FC = () => {
    const { __ } = useI18n();

    return (
        <>
            <Form.Item label={__('Affiliate link as "powered by" link')}>
                <Form.Item
                    name="affiliateLink"
                    noStyle
                    rules={[
                        {
                            type: "url",
                            message: __("Please provide a valid url!"),
                        },
                    ]}
                >
                    <Input />
                </Form.Item>
                <p className="description">
                    {__(
                        'You can replace the "powered by" link in the cookie banner with your affiliate link. This allows you to earn affiliate commissions if interested users find Real Cookie Banner when they visit your website.',
                    )}
                </p>
            </Form.Item>
            <Form.Item
                noStyle
                shouldUpdate={(prevValues, nextValues) => prevValues.affiliateLink !== nextValues.affiliateLink}
            >
                {({ getFieldValue }) =>
                    !!getFieldValue("affiliateLink") && (
                        <>
                            <Form.Item label={__("Label behind the link")}>
                                <Form.Item name="affiliateLabelBehind" noStyle>
                                    <Input />
                                </Form.Item>
                                <p className="description">
                                    {__(
                                        "Depending on which country you are from, you may have to label affiliate links as advertising. You can place e.g. a text or an asterisk behind the link.",
                                    )}
                                </p>
                            </Form.Item>
                            <Form.Item
                                noStyle
                                shouldUpdate={(prevValues, nextValues) =>
                                    prevValues.affiliateLabelBehind !== nextValues.affiliateLabelBehind
                                }
                            >
                                {({ getFieldValue }) =>
                                    !!getFieldValue("affiliateLabelBehind") && (
                                        <Form.Item label={__("Description")} name="affiliateLabelDescription">
                                            <Input />
                                        </Form.Item>
                                    )
                                }
                            </Form.Item>
                        </>
                    )
                }
            </Form.Item>
        </>
    );
};

export { FormSettingsAffiliateTabContent };
