import { Form, Space } from "antd";

import { useFormSettings } from "../../../contexts/formSettings.js";
import { useI18n } from "../../../contexts/i18n.js";

import type { FC } from "react";

const FormSettingsFooter: FC = () => {
    const { __ } = useI18n();
    const { isTcf, activeTab, onStartTcfVendorConfiguration } = useFormSettings();

    return (
        <Form.Item
            className="rcb-antd-form-sticky-submit"
            colon={false}
            labelAlign="left"
            label={
                <a className="button button-link" href="#/settings/reset">
                    {__("Reset plugin and texts")}
                </a>
            }
            style={{ textAlign: "center" }}
        >
            <Space direction="horizontal">
                {isTcf && activeTab === "tcf" && (
                    <button
                        className="button"
                        onClick={() => onStartTcfVendorConfiguration()}
                        style={{ marginRight: 10 }}
                    >
                        {__("Start vendor configuration")}
                    </button>
                )}
                <input type="submit" className="button button-primary" value={__("Save settings")} />
            </Space>
        </Form.Item>
    );
};

export { FormSettingsFooter };
