import { Checkbox, Form } from "antd";

import { FormServiceLayout } from "./layout.js";
import { useFormContentBlocker } from "../../contexts/formContentBlocker.js";
import { useFormService } from "../../contexts/formService.js";
import { useI18n } from "../../contexts/i18n.js";

import type { FC } from "react";

const FormFieldTemplateSuccessorDeletionCheck: FC<{ type: "service" | "blocker" }> = ({ type }) => {
    const { __ } = useI18n();
    const { template, isEdit } = type === "service" ? useFormService() : useFormContentBlocker();

    return (
        template?.consumerData.successorOf.length > 0 &&
        !isEdit && (
            <Form.Item<{ succeessorDeletionCheck: boolean }>
                name="succeessorDeletionCheck"
                valuePropName="checked"
                wrapperCol={{ offset: FormServiceLayout.labelCol.span }}
            >
                <Checkbox>
                    {type === "service"
                        ? __(
                              "Replace the previous service with this one. The old one should be deleted when this one is saved.",
                          )
                        : __(
                              "Replace the previous content blocker with this one. The old one should be deleted when this one is saved.",
                          )}
                </Checkbox>
            </Form.Item>
        )
    );
};

export { FormFieldTemplateSuccessorDeletionCheck };
