import { Empty, Table } from "antd";
import { useMemo } from "react";

import { FORM_TCF_VENDOR_FIELD_PURPOSES_COLUMN_NAME_WIDTH } from "./purposes.js";
import { useFormTcfVendor } from "../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../contexts/i18n.js";
import { FormHeadline } from "../../headline.js";
import { FormLayoutTcfVendor } from "../../layout.js";

import type { DataCategory } from "@iabtechlabtcf/core";
import type { FC } from "react";

const { Column } = Table;

const FormTcfVendorFieldDataDeclaration: FC = () => {
    const { __ } = useI18n();

    const {
        vendor,
        declarations: { dataCategories },
    } = useFormTcfVendor();

    const useDataDeclarations = useMemo(
        () =>
            Object.values(dataCategories).filter(
                (dataCategory) => vendor.dataDeclaration.indexOf(dataCategory.id) > -1,
            ),
        [vendor, dataCategories],
    );

    return (
        <>
            <FormHeadline
                offset={FormLayoutTcfVendor.labelCol.span}
                description={__(
                    "Data categories are specified by the vendor and are immutable. They describe the characteristics of which personal data is processed.",
                )}
            >
                {__("Data categories")}
            </FormHeadline>
            <Table<DataCategory>
                locale={{ emptyText: <Empty description={__("This vendor has not listed any data categories.")} /> }}
                dataSource={useDataDeclarations}
                rowKey="id"
                size="small"
                bordered
                pagination={false}
            >
                <Column<DataCategory>
                    width={FORM_TCF_VENDOR_FIELD_PURPOSES_COLUMN_NAME_WIDTH}
                    title={__("Name")}
                    dataIndex="name"
                    key="name"
                />
                <Column<DataCategory> title={__("Description")} dataIndex="description" key="description" />
            </Table>
        </>
    );
};

export { FormTcfVendorFieldDataDeclaration };
