import { FormTcfVendorFieldGeneralDataProcessingInCountries } from "./dataProcessingInCountries.js";
import { FormTcfVendorFieldGeneralDataProcessingInCountriesSpecialTreatments } from "./dataProcessingInCountriesSpecialTreatments.js";
import { FormTcfVendorFieldGeneralLegalAddress } from "./legalAddress.js";
import { FormTcfVendorFieldGeneralPrivacyPolicyUrl } from "./privacyPolicyUrl.js";
import { FormTcfVendorFieldGeneralProvider } from "./provider.js";
import { FormTcfVendorFieldGeneralStatus } from "./status.js";
import { FormTcfVendorFieldGeneralTerritorialScope } from "./territorialScope.js";
import { useI18n } from "../../../../../contexts/i18n.js";
import { FormHeadline } from "../../../headline.js";
import { FormLayoutTcfVendor } from "../../../layout.js";

import type { FC } from "react";

const FormTcfVendorFieldGeneralCompose: FC = () => {
    const { __ } = useI18n();

    return (
        <>
            <FormHeadline offset={FormLayoutTcfVendor.labelCol.span}>{__("General vendor configuration")}</FormHeadline>
            <FormTcfVendorFieldGeneralProvider />
            <FormTcfVendorFieldGeneralStatus />
            <FormTcfVendorFieldGeneralLegalAddress />
            <FormTcfVendorFieldGeneralPrivacyPolicyUrl />
            <FormTcfVendorFieldGeneralTerritorialScope />
            <FormTcfVendorFieldGeneralDataProcessingInCountries />
            <FormTcfVendorFieldGeneralDataProcessingInCountriesSpecialTreatments />
        </>
    );
};

export { FormTcfVendorFieldGeneralCompose };
