import { Form, Select } from "antd";

import { useFormTcfVendor } from "../../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralDataProcessingInCountries: FC = () => {
    const { __ } = useI18n();
    const { iso3166OneAlpha2 } = useFormTcfVendor();

    return (
        <Form.Item<FormTcfVendorValueProps> label={__("Data processing in countries")}>
            <Form.Item<FormTcfVendorValueProps> name="dataProcessingInCountries" noStyle>
                <Select mode="multiple" showSearch optionFilterProp="children" maxTagCount="responsive">
                    {Object.keys(iso3166OneAlpha2).map((code) => (
                        <Select.Option value={code} key={code}>
                            {iso3166OneAlpha2[code]}
                        </Select.Option>
                    ))}
                </Select>
            </Form.Item>
            <p className="description">
                {__(
                    "Data is usually processed in the countries where the vendor has its headquarter or servers. You should check with your service provider where your users' data is processed.",
                )}
            </p>
        </Form.Item>
    );
};

export { FormTcfVendorFieldGeneralDataProcessingInCountries };
