import { Form, Input } from "antd";

import { useFormTcfVendor } from "../../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralLegalAddress: FC = () => {
    const { __ } = useI18n();
    const {
        vendor: { additionalInformation },
    } = useFormTcfVendor();

    return (
        <Form.Item<FormTcfVendorValueProps> label={__("Legal address")}>
            <Input.TextArea value={additionalInformation?.legalAddress.split(";").join("\n") || ""} readOnly autoSize />
        </Form.Item>
    );
};

export { FormTcfVendorFieldGeneralLegalAddress };
