import { Form, Input } from "antd";

import { useFormTcfVendor } from "../../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralPrivacyPolicyUrl: FC = () => {
    const { __ } = useI18n();
    const {
        vendor: { urls },
    } = useFormTcfVendor();

    const { privacy, legIntClaim } = urls?.[0] || {
        langId: "",
        privacy: "",
        legIntClaim: "",
    };

    return (
        <>
            <Form.Item<FormTcfVendorValueProps> label={__("Privacy policy of the provider")}>
                <Input value={privacy} readOnly />
            </Form.Item>
            <Form.Item<FormTcfVendorValueProps> label={__("Explanation of the legitimate interest")}>
                <Input value={legIntClaim} readOnly />
            </Form.Item>
        </>
    );
};

export { FormTcfVendorFieldGeneralPrivacyPolicyUrl };
