import { Form, Input } from "antd";

import { useFormTcfVendor } from "../../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralProvider: FC = () => {
    const { __ } = useI18n();
    const {
        vendor: { id, name },
    } = useFormTcfVendor();

    return (
        <Form.Item<FormTcfVendorValueProps> label={__("Provider")}>
            <Input value={name} readOnly addonAfter={__("Vendor ID: %d", id)} />
        </Form.Item>
    );
};

export { FormTcfVendorFieldGeneralProvider };
