import { Form, Radio } from "antd";

import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralStatus: FC = () => {
    const { __ } = useI18n();

    return (
        <Form.Item<FormTcfVendorValueProps> label={__("Status")} required>
            <Form.Item<FormTcfVendorValueProps>
                name="status"
                noStyle
                rules={[{ required: true, message: __("Please choose a status!") }]}
            >
                <Radio.Group>
                    <Radio.Button value="publish">{__("Enabled")}</Radio.Button>
                    <Radio.Button value="private">{__("Disabled")}</Radio.Button>
                    <Radio.Button value="draft">{__("Draft")}</Radio.Button>
                </Radio.Group>
            </Form.Item>
            <p className="description">
                {__(
                    'Vendor configurations with the status "Draft" or "Disabled" are not visible to the public. In addition, a draft is highlighted in the table of vendor configurations so that you do not forget to complete it.',
                )}
            </p>
        </Form.Item>
    );
};

export { FormTcfVendorFieldGeneralStatus };
