import { Form, Select, Switch } from "antd";

import { useFormTcfVendor } from "../../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../../contexts/i18n.js";

import type { FormTcfVendorValueProps } from "../../../../../types/formTcfVendor.js";
import type { FC } from "react";

const FormTcfVendorFieldGeneralTerritorialScope: FC = () => {
    const { __ } = useI18n();
    const {
        iso3166OneAlpha2,
        vendor: { additionalInformation },
    } = useFormTcfVendor();

    return (
        <>
            <Form.Item<FormTcfVendorValueProps> label={__("Territorial scope")}>
                <Select
                    mode="multiple"
                    disabled
                    value={additionalInformation?.territorialScope ? [...additionalInformation.territorialScope] : []}
                >
                    {Object.keys(iso3166OneAlpha2).map((code) => (
                        <Select.Option value={code} key={code}>
                            {iso3166OneAlpha2[code]}
                        </Select.Option>
                    ))}
                </Select>
                <p className="description">
                    {__(
                        "The EU/EEA/EFTA/UK jurisdictions where the vendor operates in the context of its TCF registration. Note that this is different from the place of establishment.",
                    )}
                </p>
                <Switch checked={additionalInformation?.internationalTransfers} disabled />
                <span>&nbsp;&nbsp;{__("This vendor transfers data outside EU/EEA")}</span>
            </Form.Item>
            {additionalInformation?.internationalTransfers && (
                <Form.Item<FormTcfVendorValueProps> label={__("Transfer mechanism")}>
                    <Select
                        mode="multiple"
                        disabled
                        value={
                            additionalInformation?.transferMechanisms
                                ? [...additionalInformation.transferMechanisms]
                                : []
                        }
                    >
                        <Select.Option value={"Adequacy decision"}>{__("Adequacy decision")}</Select.Option>
                        <Select.Option value={"SCCs"}>{__("Standard contractual clauses")}</Select.Option>
                        <Select.Option value={"BCRs"}>{__("Binding corporate rules")}</Select.Option>
                        <Select.Option value={"Other"}>{__("Other")}</Select.Option>
                    </Select>
                </Form.Item>
            )}
        </>
    );
};

export { FormTcfVendorFieldGeneralTerritorialScope };
