import { Checkbox, Form } from "antd";

import { useFormTcfVendor } from "../../../../contexts/formTcfVendor.js";
import { useI18n } from "../../../../contexts/i18n.js";
import { LearnMoreTag } from "../../../common/learnMoreTag.js";
import { FormServiceLayout } from "../../layout.js";

import type { FormServiceValueProps } from "../../../../types/formService.js";
import type { FC } from "react";

const FormTcfVendorFieldTemplateCheck: FC = () => {
    const { __, _x } = useI18n();
    const { isEdit } = useFormTcfVendor();

    return (
        !isEdit && (
            <Form.Item<FormServiceValueProps>
                name="templateCheck"
                valuePropName="checked"
                required
                rules={[
                    {
                        type: "boolean",
                        required: true,
                        transform: (value) => value || undefined,
                        message: __("Please confirm that you have checked the contents of the service."),
                    },
                ]}
                wrapperCol={{ offset: FormServiceLayout.labelCol.span }}
            >
                <Checkbox>
                    {_x(
                        "I have checked the information in the TCF vendor configuration myself and corrected any information that does not fit to my use case.",
                        "legal-text",
                    )}{" "}
                    <LearnMoreTag
                        url={__("https://devowl.io/knowledge-base/is-real-cookie-banner-legally-compliant/")}
                    />
                </Checkbox>
            </Form.Item>
        )
    );
};

export { FormTcfVendorFieldTemplateCheck };
