import { Form } from "antd";
import { useRef } from "react";

import { FormTcfVendorFieldDataDeclaration } from "./fields/dataDeclaration.js";
import { FormTcfVendorFieldDeviceStorage } from "./fields/deviceStorage.js";
import { FormTcfVendorFieldFeatures } from "./fields/features.js";
import { FormTcfVendorFieldGeneralCompose } from "./fields/general/compose.js";
import { FormTcfVendorFieldPurposes } from "./fields/purposes.js";
import { FormTcfVendorFieldTemplateCheck } from "./fields/templateCheck.js";
import { useI18n } from "../../../contexts/i18n.js";
import { FormLayoutTcfVendor } from "../layout.js";

import type { FC } from "react";

const FormTcfVendor: FC = () => {
    const { __ } = useI18n();

    const ref = useRef();

    return (
        <div ref={ref}>
            <FormTcfVendorFieldGeneralCompose />
            <FormTcfVendorFieldDeviceStorage />
            <FormTcfVendorFieldPurposes />
            <FormTcfVendorFieldFeatures />
            <FormTcfVendorFieldDataDeclaration />
            <Form.Item className="rcb-antd-form-sticky-submit" labelCol={{ span: 0 }} wrapperCol={{ span: 24 }}>
                <FormTcfVendorFieldTemplateCheck />
                <Form.Item wrapperCol={{ offset: FormLayoutTcfVendor.labelCol.span }}>
                    <div style={{ textAlign: "center" }}>
                        <input type="submit" className="button button-primary" value={__("Save")} />
                    </div>
                </Form.Item>
            </Form.Item>
        </div>
    );
};

export { FormTcfVendor };
