import { Popconfirm } from "antd";

import { useI18n } from "../../contexts/i18n.js";

import type { FC, MutableRefObject } from "react";

const FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT = "confirm:popconfirm-gateway";

const FormValueDifferFromTemplateResetButtonWithConfirm: FC<{
    anchorRef: MutableRefObject<HTMLAnchorElement>;
}> = ({ anchorRef }) => {
    const { __ } = useI18n();

    return (
        <Popconfirm
            title={__(
                "Do you really want to irrevocably overwrite all changes to this form with the defaults from the latest version of the template?",
            )}
            cancelText={__("Cancel")}
            okText={__("Reset now")}
            overlayStyle={{ maxWidth: 450 }}
            onConfirm={() =>
                anchorRef.current.dispatchEvent(new CustomEvent(FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT))
            }
            placement="topLeft"
        >
            <a style={{ display: "none" }} ref={anchorRef}>
                {__("Reset to latest template version")}
            </a>
        </Popconfirm>
    );
};

export { FORM_DIFFER_RESET_BUTTON_WITH_CONFIRM_CUSTOM_EVENT, FormValueDifferFromTemplateResetButtonWithConfirm };
