import { PlusOutlined, SearchOutlined } from "@ant-design/icons";
import { Card } from "antd";

import { useI18n } from "../../contexts/i18n.js";
import { useTemplateCenter } from "../../contexts/templateCenter.js";
import { COOKIE_EXPERTS_LOGO_URL, useCookieExpertsModal } from "../../hooks/useCookieExpertsModal.js";

import type { TemplateCenterCard } from "./card.js";
import type { ComponentProps, FC } from "react";

const { Meta } = Card;

const TemplateCenterHeader: FC<{ onSelect?: ComponentProps<typeof TemplateCenterCard>["onSelect"] }> = ({
    onSelect,
}) => {
    const { __ } = useI18n();
    const { quickLinks } = useTemplateCenter();
    const { openDialog: openCookieExperts } = useCookieExpertsModal();

    return (
        <>
            {quickLinks
                .map((link) => {
                    if (typeof link === "string") {
                        switch (link) {
                            case "cookie-experts":
                                return {
                                    id: "cookie-experts",
                                    cover: (
                                        <img
                                            src={COOKIE_EXPERTS_LOGO_URL}
                                            style={{ display: "block", paddingTop: 15, margin: "auto", height: 81 }}
                                        />
                                    ),
                                    title: "Cookie Experts",
                                    description: __("help you with the setup"),
                                    onClick: openCookieExperts,
                                };
                            case "service-individual":
                                return {
                                    id: "from-scratch",
                                    cover: <PlusOutlined style={{ paddingTop: 25, fontSize: 70 }} />,
                                    title: __("Create from scratch"),
                                    description: __("an individual service"),
                                    onClick: () => onSelect(undefined),
                                };
                            case "blocker-individual":
                                return {
                                    id: "from-scratch",
                                    cover: <PlusOutlined style={{ paddingTop: 25, fontSize: 70 }} />,
                                    title: __("Create from scratch"),
                                    description: __("an individual content blocker"),
                                    onClick: () => onSelect(undefined),
                                };
                            case "service-scanner":
                                return {
                                    id: "scanner",
                                    cover: <SearchOutlined style={{ paddingTop: 25, fontSize: 70 }} />,
                                    title: __("Scan website"),
                                    description: __("and find used service"),
                                    onClick: () => (window.location.hash = "#/scanner"),
                                };
                            default:
                                break;
                        }
                    }
                    return link;
                })
                .map(({ id, cover, description, onClick, title }) => (
                    <Card
                        key={id}
                        hoverable
                        style={{ margin: 5, width: 240, display: "inline-block" }}
                        onClick={onClick}
                        cover={cover}
                    >
                        <Meta title={title} description={description} />
                    </Card>
                ))}
        </>
    );
};

export { TemplateCenterHeader };
