import { Col, Divider, Row } from "antd";

import type { FC } from "react";

type UpsellModalHintProps = {
    logo?: string;
    title: string;
    description?: string;
    link?: string;
    linkText?: string;
};

const UpsellModalHint: FC<UpsellModalHintProps> = ({ title, description, link, linkText, logo }) => {
    return (
        <>
            <Divider>{title}</Divider>
            <Row wrap={false} style={{ marginBottom: 10 }}>
                <Col flex="auto">
                    {!!description && (
                        <p style={{ margin: 0 }}>
                            <span dangerouslySetInnerHTML={{ __html: description }} />
                            &nbsp;
                            {!!link && !!linkText && (
                                <a href={link} target="_blank" rel="noreferrer" className="button-link">
                                    {linkText}
                                </a>
                            )}
                        </p>
                    )}
                </Col>
                <Col flex="150px" style={{ alignSelf: "center" }}>
                    {!!logo && (
                        <img src={logo} style={{ maxWidth: "calc(100% - 20px)", height: "auto", marginLeft: 20 }} />
                    )}
                </Col>
            </Row>
        </>
    );
};

export { UpsellModalHint, type UpsellModalHintProps };
