import { useUpsellModal } from "../../hooks/useUpsellModal.js";

import type { UpsellFeature } from "./modal.js";
import type { FC, HTMLAttributes, PropsWithChildren } from "react";

const UpsellTag: FC<PropsWithChildren<UpsellFeature & { wrapperAttributes?: HTMLAttributes<HTMLSpanElement> }>> = ({
    children,
    wrapperAttributes = {},
    ...feature
}) => {
    const { modal, tag } = useUpsellModal(feature);

    return (
        <>
            {modal}
            <span {...wrapperAttributes}>{tag}</span>
        </>
    );
};

export { UpsellTag };
