import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";
import type { ClientBlockerTemplate } from "@devowl-wp/service-cloud-consumer";

import type { FormContentBlockerValueProps } from "../types/formContentBlocker.js";
import type { FormSettingsValueProps } from "../types/formSettings.js";
import type { Purpose } from "@iabtechlabtcf/core";

const FORM_CONTENT_BLOCKER_CONTEXT_SYMBOL = Symbol();
type FormContentBlockerContext = ImmutableContext<{
    initialState: Partial<
        Pick<FormSettingsValueProps, "isTcf"> & {
            template: ClientBlockerTemplate["use"];
            tcfPurposes: Purpose[];
            isEdit: boolean;
            initialHasChanges: boolean;
            isTemplateUpdate: boolean;
            templateCheck: boolean;
            /**
             * Allows to reset some fields depending on new values of a defined template.
             */
            defaultTemplateValues: Partial<FormContentBlockerValueProps>;
        }
    >;
}>;

const useFormContentBlocker: FnCreateImmutableContextForSymbol<FormContentBlockerContext> = () =>
    useImmutableContext<FormContentBlockerContext>(FORM_CONTENT_BLOCKER_CONTEXT_SYMBOL);

const useFormContentBlockerProvider: FnCreateImmutableContextProviderForSymbol<FormContentBlockerContext> = (...args) =>
    useImmutableContextProvider<FormContentBlockerContext>(FORM_CONTENT_BLOCKER_CONTEXT_SYMBOL, ...args);

export { type FormContentBlockerContext, useFormContentBlocker, useFormContentBlockerProvider };
