import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { FormServiceGroupValueProps } from "../types/formServiceGroup.js";
import type { ComponentProps } from "react";

const FORM_SERVICE_GROUP_CONTEXT_SYMBOL = Symbol();
type FormServiceGroupContext = ImmutableContext<{
    initialState: Partial<{
        onCancel: () => void;
        recordId?: number;
        languages?: ListMultilingualLanguagesRecords;
        languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
        /**
         * Allows to reset some fields depending on new values of a defined template.
         */
        defaultTemplateValues: Partial<FormServiceGroupValueProps>;
    }>;
}>;

const useFormServiceGroup: FnCreateImmutableContextForSymbol<FormServiceGroupContext> = () =>
    useImmutableContext<FormServiceGroupContext>(FORM_SERVICE_GROUP_CONTEXT_SYMBOL);

const useFormServiceGroupProvider: FnCreateImmutableContextProviderForSymbol<FormServiceGroupContext> = (...args) =>
    useImmutableContextProvider<FormServiceGroupContext>(FORM_SERVICE_GROUP_CONTEXT_SYMBOL, ...args);

export { type FormServiceGroupContext, useFormServiceGroup, useFormServiceGroupProvider };
