import type { CookieConsentManagerOptions } from "@devowl-wp/cookie-consent-web-client";
import type { CommonContextProps } from "@devowl-wp/react-cookie-banner";
import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type { FormSettingsValueProps, FormSettingsValuePropsNavItem } from "../types/formSettings.js";
import type { FC } from "react";

const FORM_SETTINGS_CONTEXT_SYMBOL = Symbol();
type FormSettingsContext = ImmutableContext<{
    initialState: Partial<{
        iso3166OneAlpha2: Record<string, string>;
        onCustomizeClick: (id: string) => void;
        onPageEditClick: (id: number) => void;

        activeTab: string;
        onStartTcfVendorConfiguration: () => void;
        onResetAll: (resetConsents: boolean) => void;
        resetTextsLanguages: {
            name: string;
            code: string;
            isRequired?: boolean;
            isDisabled?: boolean;
            notice?: string;
        }[];
        onResetTexts: (languages: string[]) => void;

        // General tab
        renderPageSelector: FC<{
            id: string;
            multiple: boolean;
            disabled: boolean;
            selectedPageContent?: (html: string) => void;
            selectedPageUrl?: (url: string) => void;
            onlyPages?: boolean;
            value?: any;
            onChange?: (value: any) => void;
        }>;
        onHasPrivacyPolicyRCBSentenceChanged: (state: boolean) => void;

        // Consent tab
        /**
         * When was the last time consents got deleted / cleaned up?
         * This value is passed to the `Date` constructor.
         */
        consentsDeletedAt: string | number;
        predefinedDataProcessingInSafeCountriesLists: CommonContextProps["predefinedDataProcessingInSafeCountriesLists"];
        /**
         * Age notice text, needed for `ageNoticeAgeLimit`. When the notice text does not contain
         * `{{minAge}}` the dropdown will not be rendered.
         *
         * @deprecated Will be removed in future versions
         */
        ageNotice: string;
        ageNoticeCountryAgeMap: Record<string, number>;

        // Country Bypass tab
        predefinedCountryBypassLists: Record<string, string[]>;
        /**
         * Initial value of `isCountryBypass`. This is needed to calculate the need of term checkboxes.
         */
        isCountryBypass: boolean;
        /**
         * When was the last time the Geo database got downloaded?
         * This value is passed to the `Date` constructor.
         */
        countryBypassDbDownloadTime: string | number;

        // TCF tab
        isTcf: boolean;
        /**
         * When was the last time the TCF feature got activated?
         * This value is passed to the `Date` constructor.
         */
        tcfAcceptedTime: string | number;
        /**
         * When was the last time the TCF GVL database got activated?
         * This value is passed to the `Date` constructor.
         */
        tcfGvlDownloadTime: string | number;

        // Google Consent Mode tab
        isGcm: CookieConsentManagerOptions["isGcm"];

        multisiteEndpoints: {
            current: Record<string, string>;
            forwardTo: Record<string, string>;
        };

        bannerlessConsentChecks: Record<
            "essential" | "legalBasisConsentWithoutVisualContentBlocker" | "legalBasisLegitimateInterest",
            Array<{
                name: string;
                id: number;
                groupId: number;
            }>
        >;
    }>;
    modifiers: {
        onCountryBypassUpdateDatabase: () => Promise<void>;
        onTcfUpdateDatabase: () => Promise<void>;
        fetchMultisiteEndpoints: () => Promise<void>;
        createCookiePolicy?: () => Promise<
            Pick<FormSettingsValuePropsNavItem, "pageId"> & {
                onNewNavLinks: (navLinks: FormSettingsValuePropsNavItem[]) => Promise<void>;
            }
        >;
        deactivateCookiePolicy?: (id: FormSettingsValueProps["cookiePolicyId"]) => Promise<{
            onNewNavLinks: (navLinks: FormSettingsValuePropsNavItem[]) => Promise<void>;
        }>;
    };
}>;

const useFormSettings: FnCreateImmutableContextForSymbol<FormSettingsContext> = () =>
    useImmutableContext<FormSettingsContext>(FORM_SETTINGS_CONTEXT_SYMBOL);

const useFormSettingsProvider: FnCreateImmutableContextProviderForSymbol<FormSettingsContext> = (...args) =>
    useImmutableContextProvider<FormSettingsContext>(FORM_SETTINGS_CONTEXT_SYMBOL, ...args);

export { type FormSettingsContext, useFormSettings, useFormSettingsProvider };
