import type { ITcfVendorList } from "@devowl-wp/api-real-cookie-banner";
import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type { FormServiceContext } from "./formService.js";
import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { FormTcfVendorValueProps } from "../types/formTcfVendor.js";
import type { Declarations, Vendor } from "@iabtechlabtcf/core";
import type { ComponentProps } from "react";

const FORM_TCF_VENDOR_CONTEXT_SYMBOL = Symbol();
type FormTcfVendorContext = ImmutableContext<{
    initialState: Partial<
        Pick<
            FormServiceContext["contextValue"],
            "territorialLegalBasis" | "iso3166OneAlpha2" | "predefinedDataProcessingInSafeCountriesLists" | "isEdit"
        > & {
            vendor: Vendor &
                Pick<
                    ITcfVendorList["composedVendorList"]["vendors"][""],
                    "deviceStorageDisclosure" | "additionalInformation" | "deviceStorageDisclosureViolation"
                >;
            declarations: Omit<Declarations, "stacks">;
            languages?: ListMultilingualLanguagesRecords;
            languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
            /**
             * Allows to reset some fields depending on new values of a defined template.
             */
            defaultTemplateValues: Partial<FormTcfVendorValueProps>;
        }
    >;
}>;

const useFormTcfVendor: FnCreateImmutableContextForSymbol<FormTcfVendorContext> = () =>
    useImmutableContext<FormTcfVendorContext>(FORM_TCF_VENDOR_CONTEXT_SYMBOL);

const useFormTcfVendorProvider: FnCreateImmutableContextProviderForSymbol<FormTcfVendorContext> = (...args) =>
    useImmutableContextProvider<FormTcfVendorContext>(FORM_TCF_VENDOR_CONTEXT_SYMBOL, ...args);

export { type FormTcfVendorContext, useFormTcfVendor, useFormTcfVendorProvider };
