import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

const I18N_CONTEXT_SYMBOL = Symbol();
type I18nContext = ImmutableContext<{
    initialState: Partial<Pick<RegexpTranslationExtractor.TranslationFunctions, "__" | "_i" | "_n" | "_x">>;
}>;

const useI18n: FnCreateImmutableContextForSymbol<I18nContext> = () =>
    useImmutableContext<I18nContext>(I18N_CONTEXT_SYMBOL);

const useI18nProvider: FnCreateImmutableContextProviderForSymbol<I18nContext> = (...args) =>
    useImmutableContextProvider<I18nContext>(I18N_CONTEXT_SYMBOL, ...args);

export { type I18nContext, useI18n, useI18nProvider };
