import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { FormContentBlockerValueProps } from "../types/formContentBlocker.js";
import type { ComponentProps } from "react";

type ListContentBlockerRowAttributes = {
    id: number;
    rules: string[];

    presetId?: string;
} & Pick<
    FormContentBlockerValueProps,
    "name" | "description" | "status" | "services" | "criteria" | "tcfVendors" | "isVisual"
>;

type ListContentBlockerRowProps = {
    busy: boolean;
    attributes: ListContentBlockerRowAttributes;
    avatarUrl?: string;
    isUpdateAvailable?: boolean;
    languages?: ListMultilingualLanguagesRecords;
    languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
};

const LIST_CONTENT_BLOCKER_SYMBOL = Symbol();
type ListContentBlockerContext = ImmutableContext<{
    initialState: Partial<{
        busy: boolean;
        serviceCount: number;
        contentBlockerCount: number;
        rows: Array<ListContentBlockerRowProps>;
    }>;
    modifiers: {
        onCreate: () => void;
        onEdit: (id: ListContentBlockerRowAttributes["id"]) => void;
        onDelete: (id: ListContentBlockerRowAttributes["id"]) => void;
    };
}>;

const useListContentBlocker: FnCreateImmutableContextForSymbol<ListContentBlockerContext> = () =>
    useImmutableContext<ListContentBlockerContext>(LIST_CONTENT_BLOCKER_SYMBOL);

const useListContentBlockerProvider: FnCreateImmutableContextProviderForSymbol<ListContentBlockerContext> = (...args) =>
    useImmutableContextProvider<ListContentBlockerContext>(LIST_CONTENT_BLOCKER_SYMBOL, ...args);

export {
    type ListContentBlockerRowAttributes,
    type ListContentBlockerRowProps,
    type ListContentBlockerContext,
    useListContentBlocker,
    useListContentBlockerProvider,
};
