import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { FormServiceValueProps } from "../types/formService.js";
import type { FormSettingsValueProps } from "../types/formSettings.js";
import type { ComponentProps } from "react";

type ListServiceRowAttributes = {
    id: number;

    // UI-specific options
    /**
     * Is this service defined as essential?
     */
    isEssential: boolean;
    deleteHint: string[];
    deletable: boolean;
    presetId?: string;
} & Pick<
    FormServiceValueProps,
    | "name"
    | "purpose"
    | "status"
    | "isEmbeddingOnlyExternalResources"
    | "uniqueName"
    | "technicalDefinitions"
    | "legalBasis"
    | "tagManagerOptInEventName"
    | "tagManagerOptOutEventName"
    | "codeOptIn"
    | "codeOptOut"
    | "deleteTechnicalDefinitionsAfterOptOut"
    | "codeOnPageLoad"
    | "executeCodeOptInWhenNoTagManagerConsentIsGiven"
    | "executeCodeOptOutWhenNoTagManagerConsentIsGiven"
>;

type ListServiceRowProps = {
    busy: boolean;
    attributes: ListServiceRowAttributes;
    avatarUrl?: string;
    isUpdateAvailable?: boolean;
    languages?: ListMultilingualLanguagesRecords;
    languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
};

const LIST_SERVICE_SYMBOL = Symbol();
type ListServiceContext = ImmutableContext<{
    initialState: Partial<
        Pick<
            FormSettingsValueProps,
            "isDataProcessingInUnsafeCountries" | "isConsentForwarding" | "setCookiesViaManager" | "isGcm"
        > & {
            busy: boolean;
            rows: Array<ListServiceRowProps>;
            servicesCount: number;
            groupName: string;
            /**
             * Is this list only holding essential services (e.g. filtering / tabs by groups)?
             */
            isEssential: boolean;
            isOnlyRealCookieBannerServiceCreated: boolean;
        }
    >;
    modifiers: {
        onSort: (ids: ListServiceRowProps["attributes"]["id"][], from: number, to: number) => void;
        onEdit: (id: ListServiceRowAttributes["id"]) => void;
        onDelete: (id: ListServiceRowAttributes["id"]) => void;
        onCreate: () => void;
    };
}>;

const useListService: FnCreateImmutableContextForSymbol<ListServiceContext> = () =>
    useImmutableContext<ListServiceContext>(LIST_SERVICE_SYMBOL);

const useListServiceProvider: FnCreateImmutableContextProviderForSymbol<ListServiceContext> = (...args) =>
    useImmutableContextProvider<ListServiceContext>(LIST_SERVICE_SYMBOL, ...args);

export {
    type ListServiceRowAttributes,
    type ListServiceRowProps,
    type ListServiceContext,
    useListService,
    useListServiceProvider,
};
