import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type { FormTcfVendorContext } from "./formTcfVendor.js";
import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { useTableBulkAction } from "../hooks/useTableBulkAction.js";
import type { FormTcfVendorValueProps } from "../types/formTcfVendor.js";
import type { ComponentProps } from "react";

type ListTcfVendorRowAttributes = {
    id: number;
    vendorId: number;
    /**
     * Does this configuration have a connected content blocker? Pass the
     * ID or `false`.
     */
    blocker?: number | false;
} & Pick<FormTcfVendorValueProps, "status" | "restrictivePurposes">;

type ListTcfVendorRowProps<Mode extends "vendor-configurations" | "vendors"> = {
    busy: boolean;
} & (Mode extends "vendor-configurations"
    ? {
          configuration: ListTcfVendorRowAttributes;
          /**
           * Keep empty when the vendor is no longer available in the GVL.
           */
          vendor?: FormTcfVendorContext["initialState"]["vendor"];
          languages?: ListMultilingualLanguagesRecords;
          languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
      }
    : {
          vendor: FormTcfVendorContext["initialState"]["vendor"];
          configuration: boolean;
          blocker: ListTcfVendorRowAttributes["blocker"];
      });

const LIST_TCF_VENDOR_SYMBOL = Symbol();
type ListTcfVendorContext = ImmutableContext<{
    initialState: Partial<
        {
            busy: boolean;
            vendorCount: number;
            /**
             * A list of available networks which we can subscribe to. Each network is a group of predefined vendor list IDs.
             */
            adNetworks: Array<{
                identifier: string;
                name: string;
                description: string;
                provider: string;
                logo: string;
                updatedAt: string;
                hasRealTimeApi?: boolean;
                createContentBlockerForVendorId?: number;
                onCreateOrEditContentBlocker?: () => void;
                lists: Array<{
                    name: string;
                    description: string;
                    vendorIds: number[];
                    isRecommended?: boolean;
                }>;
            }>;
        } & (
            | {
                  /**
                   * Show a list of all created vendor configurations.
                   */
                  view: "vendor-configurations";
                  /**
                   * List of all created vendor configurations. The component does currently
                   * not support asynchronous pagination.
                   */
                  rows: Array<ListTcfVendorRowProps<"vendor-configurations">>;
                  onSwitchToVendorView: () => void;
                  onCreateOrEditContentBlocker: (
                      configuration: ListTcfVendorRowAttributes,
                      vendor: FormTcfVendorContext["initialState"]["vendor"],
                  ) => void;
                  onEdit: (
                      configuration: ListTcfVendorRowAttributes,
                      vendor: FormTcfVendorContext["initialState"]["vendor"],
                  ) => void;
                  onDelete: (configuration: ListTcfVendorRowAttributes) => Promise<void>;
                  onBulkDelete: (
                      configurations: ListTcfVendorRowAttributes[],
                      ...rest: ReturnType<ReturnType<typeof useTableBulkAction>[0]>
                  ) => Promise<void>;
              }
            | {
                  /**
                   * Show a list of all available vendors.
                   */
                  view: "vendors";
                  /**
                   * If given, it automatically opens the "Ad network" modal dialog and preselects the network to add.
                   */
                  defaultCreateAdNetworkIdentifier?: string;
                  /**
                   * List of all available vendors from the GVL. The component does currently
                   * not support asynchronous pagination.
                   */
                  rows: Array<ListTcfVendorRowProps<"vendors">>;
                  onCreate: (vendor: FormTcfVendorContext["initialState"]["vendor"]) => void;
                  onBulkCreate: (
                      vendor: FormTcfVendorContext["initialState"]["vendor"][],
                      ...rest: ReturnType<ReturnType<typeof useTableBulkAction>[0]>
                  ) => Promise<void>;
              }
        )
    >;
}>;

const useListTcfVendor: FnCreateImmutableContextForSymbol<ListTcfVendorContext> = () =>
    useImmutableContext<ListTcfVendorContext>(LIST_TCF_VENDOR_SYMBOL);

const useListTcfVendorProvider: FnCreateImmutableContextProviderForSymbol<ListTcfVendorContext> = (...args) =>
    useImmutableContextProvider<ListTcfVendorContext>(LIST_TCF_VENDOR_SYMBOL, ...args);

export {
    type ListTcfVendorRowAttributes,
    type ListTcfVendorRowProps,
    type ListTcfVendorContext,
    useListTcfVendor,
    useListTcfVendorProvider,
};
