import type {
    FnCreateImmutableContextForSymbol,
    FnCreateImmutableContextProviderForSymbol,
    ImmutableContext,
} from "@devowl-wp/react-utils";
import { useImmutableContext, useImmutableContextProvider } from "@devowl-wp/react-utils";

import type { UpsellModalHintProps } from "../components/upsell/modalHint.js";

const UPSELL_CONTEXT_SYMBOL = Symbol();
type UpsellContext = ImmutableContext<{
    initialState: Partial<{
        isPro: boolean;
        isLicensed: boolean;
        isDemoEnv: boolean;
        proUrl: string;
        hint: UpsellModalHintProps;
        fomoCoupon: {
            coupon: string;
            valueInPercent: number;
            validUntil: string;
        };
    }>;
}>;

const useUpsell: FnCreateImmutableContextForSymbol<UpsellContext> = () =>
    useImmutableContext<UpsellContext>(UPSELL_CONTEXT_SYMBOL);

const useUpsellProvider: FnCreateImmutableContextProviderForSymbol<UpsellContext> = (...args) =>
    useImmutableContextProvider<UpsellContext>(UPSELL_CONTEXT_SYMBOL, ...args);

export { type UpsellContext, useUpsell, useUpsellProvider };
