import { App, Avatar, Divider } from "antd";
import { useCallback } from "react";

import { ASSETS_URL } from "./useUpsellModal.js";
import { useI18n } from "../contexts/i18n.js";

const COOKIE_EXPERTS_LOGO_URL = `${ASSETS_URL}cookie-experts.svg`;

const EXPERTS = ["niklas.moselewski", "mario.guenter", "matthias.guenter", "jan.karres"];

function useCookieExpertsModal() {
    const { modal } = App.useApp();
    const { __ } = useI18n();

    const openDialog = useCallback(() => {
        const avatarCachebuster = `?v=3`;
        const createdModal = modal.info({
            icon: null,
            width: 500,
            closable: true,
            okButtonProps: { style: { display: "none" } },
            content: (
                <div style={{ textAlign: "center" }}>
                    <img
                        src={COOKIE_EXPERTS_LOGO_URL}
                        style={{ display: "block", paddingTop: 15, margin: "auto", height: 176 }}
                    />
                    <h3 style={{ margin: "10px 0 0" }}>Cookie Experts</h3>
                    <p style={{ marginTop: 0 }}>{__("Let our team help you with the setup")}</p>
                    <Divider>
                        <Avatar.Group size="large">
                            {EXPERTS.map((e) => (
                                <Avatar
                                    key={e}
                                    src={`${ASSETS_URL}cookie-experts-faces/${e}.jpeg${avatarCachebuster}`}
                                />
                            ))}
                        </Avatar.Group>
                    </Divider>
                    <a
                        href={__("https://devowl.io/wordpress-real-cookie-banner/cookie-experts/")}
                        target="_blank"
                        rel="noreferrer"
                        className="button button-large button-primary"
                    >
                        {__("Get help from Cookie Experts")}
                    </a>
                    <p>
                        {__(
                            "We admit, it is not easy to find all the services, cookies, etc. The legal requirements in the EU are quite complex for many website operators. We can understand if you feel overwhelmed - if this goes far beyond what you can technically do. After you know what all has to be considered, the question of how to make your website privacy compliant does not let you sleep peacefully either.",
                        )}
                    </p>
                    <p>
                        {__(
                            "Don't worry, we have a solution for you! Our Cookie Experts have already set up many cookie banners and know exactly what they are doing. They can also set up your cookie banner quickly and easily. So, we can simply take this worry away from you.",
                        )}
                    </p>
                    <a
                        style={{
                            marginTop: 10,
                            display: "inline-block",
                        }}
                        onClick={() => createdModal.destroy()}
                    >
                        {__("Close")}
                    </a>
                </div>
            ),
        });
    }, []);

    return { openDialog };
}

export { useCookieExpertsModal, COOKIE_EXPERTS_LOGO_URL };
