import { useEffect } from "react";

import type { FormInstance } from "antd";

function useFormInitiallyScrollToField(form: FormInstance, field: string) {
    useEffect(() => {
        setTimeout(() => {
            form.scrollToField(field, { behavior: "smooth", block: "center" });
        }, 0);
    }, [field]);
}

export { useFormInitiallyScrollToField };
