import { useMemo } from "react";

import { useI18n } from "../contexts/i18n.js";

function useNavLinksPageTypes() {
    const { __ } = useI18n();
    return useMemo(
        () =>
            [
                {
                    name: "legalNotice",
                    label: __("Legal notice"),
                    multiple: false,
                },
                {
                    name: "privacyPolicy",
                    label: __("Privacy policy"),
                    multiple: false,
                },
                {
                    name: "gtc",
                    label: __("General terms and conditions"),
                    multiple: false,
                },
                {
                    name: "tos",
                    label: __("Terms of use"),
                    multiple: false,
                },
                {
                    name: "cancellationPolicy",
                    label: __("Cancellation policy"),
                    multiple: false,
                },
                {
                    name: "cookiePolicy",
                    label: __("Cookie policy"),
                    multiple: false,
                },
                {
                    name: "dpa",
                    label: __("Data processing agreement"),
                    multiple: false,
                },
                {
                    name: "disputeResolution",
                    label: __("Dispute resolution"),
                    multiple: false,
                },
                {
                    name: "other",
                    label: __("Other"),
                    multiple: true,
                },
            ] as const,
        [],
    );
}

export { useNavLinksPageTypes };
