import { Tooltip } from "antd";
import { useMemo } from "react";

import { EServiceTemplateDataProcessingInCountriesSpecialTreatment } from "@devowl-wp/api-real-cookie-banner";
import type { CommonContextProps } from "@devowl-wp/react-cookie-banner";
import { reactNl2Br } from "@devowl-wp/react-utils";

import { useTerritorialLegalBasisArticles } from "./useTerritorialLegalBasisArticles.js";

import type { I18nContext } from "../contexts/i18n.js";
import type { CheckboxOptionType } from "antd";

function useServiceDataProcessingCountriesSpecialTreatments({
    __,
    _i,
    predefinedDataProcessingInSafeCountriesLists,
    iso3166OneAlpha2,
    territorialLegalBasis,
}: Pick<I18nContext["contextValue"], "__" | "_i"> &
    Pick<
        CommonContextProps,
        "predefinedDataProcessingInSafeCountriesLists" | "iso3166OneAlpha2" | "territorialLegalBasis"
    >): CheckboxOptionType[] {
    const calculateTerritorialLegalBasisArticles = useTerritorialLegalBasisArticles({
        predefinedDataProcessingInSafeCountriesLists,
        iso3166OneAlpha2,
    });
    const { safeCountriesList } = calculateTerritorialLegalBasisArticles(territorialLegalBasis);

    return useMemo(() => {
        return [
            {
                label: (
                    <>
                        {__(
                            "Trans-Atlantic Data Privacy Framework self-certified provider for secure data processing in the USA",
                        )}
                        <p className="description">
                            {_i(
                                __(
                                    'The adequacy decision for secure data processing only applies if the provider is self certified and included in the "Data Privacy Framework List". To find out which companies are certified, {{a}}visit the website of the US government{{/a}}.',
                                ),
                                {
                                    a: (
                                        <a
                                            href={__("https://www.dataprivacyframework.gov/list")}
                                            rel="noreferrer"
                                            target="_blank"
                                        />
                                    ),
                                },
                            )}
                        </p>
                    </>
                ),
                value: EServiceTemplateDataProcessingInCountriesSpecialTreatment.ProviderIsSelfCertifiedTransAtlanticDataPrivacyFramework,
            },
            {
                label: (
                    <>
                        {__("Standard contractual clauses concluded with the provider")}
                        <p className="description">
                            {_i(
                                __(
                                    "Did you sign a contract with the provider, e.g. when registering online? If so, the contract may contain {{a}}standard contractual clauses{{/a}} of the EU, which promise secure data processing in unsafe third countries.",
                                ),
                                {
                                    a: (
                                        <a
                                            href={__(
                                                "https://commission.europa.eu/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en",
                                            )}
                                            rel="noreferrer"
                                            target="_blank"
                                        />
                                    ),
                                },
                            )}
                        </p>
                    </>
                ),
                value: EServiceTemplateDataProcessingInCountriesSpecialTreatment.StandardContractualClauses,
            },
            {
                label: (
                    <>
                        {__(
                            "Standard contractual clauses concluded by the provider with sub-processors processing data in unsafe third countries, contractually assured",
                        )}
                        <p className="description">
                            {_i(
                                __(
                                    "Did you sign a contract with the provider {{ud}}{{t}}from a safe country{{/t}}{{/ud}}, e.g. when registering online? If so, the contract may contain information (e.g. in a data processing agreement) if the service provider has concluded {{a}}standard contractual clauses{{/a}} of the EU {{u}}with his own processors{{/u}}, which promise secure data processing in unsafe third countries.",
                                ),
                                {
                                    t: (
                                        <Tooltip
                                            title={
                                                <>
                                                    {__(
                                                        "Safe countries are those in which the given legal regulations apply or for which adequacy decisions exist. In your case, these are:",
                                                    )}
                                                    <br />
                                                    <br />
                                                    {reactNl2Br(safeCountriesList.SAFE)}
                                                </>
                                            }
                                            overlayStyle={{ maxWidth: 500 }}
                                        />
                                    ),
                                    a: (
                                        <a
                                            href={__(
                                                "https://commission.europa.eu/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en",
                                            )}
                                            rel="noreferrer"
                                            target="_blank"
                                        />
                                    ),
                                    u: <u />,
                                    ud: <u style={{ textDecorationStyle: "dashed" }} />,
                                },
                            )}
                        </p>
                    </>
                ),
                value: EServiceTemplateDataProcessingInCountriesSpecialTreatment.ContractualAssurancesWithSubProcessors,
            },
        ];
    }, []);
}

export { useServiceDataProcessingCountriesSpecialTreatments };
