import { SearchOutlined } from "@ant-design/icons";
import { Input } from "antd";
import { useCallback } from "react";

import { useI18n } from "../contexts/i18n.js";

import type { Table } from "antd";
import type { ComponentProps } from "react";

function useTableColumnFilterSimpleInput() {
    const { __ } = useI18n();

    return useCallback((): Partial<ComponentProps<typeof Table.Column>> => {
        return {
            filterDropdown: ({ setSelectedKeys, selectedKeys, confirm, clearFilters }) => (
                <div style={{ padding: 8 }}>
                    <Input
                        autoFocus
                        value={selectedKeys[0]}
                        onChange={(e) => setSelectedKeys(e.target.value ? [e.target.value] : [])}
                        style={{ width: 188, marginBottom: 8, display: "block" }}
                    />
                    <button className="button-primary right" style={{ marginLeft: 10 }} onClick={() => confirm()}>
                        <SearchOutlined /> {__("Search")}
                    </button>
                    <button className="button right" onClick={clearFilters}>
                        {__("Reset")}
                    </button>
                    <div className="clear" />
                </div>
            ),
            filterIcon: (filtered) => <SearchOutlined style={{ color: filtered ? "#1890ff" : undefined }} />,
        };
    }, []);
}

export { useTableColumnFilterSimpleInput };
