import { useUpsellModal } from "./useUpsellModal.js";
import { useI18n } from "../contexts/i18n.js";

function useUpsellModalVisualContentBlocker() {
    const { __ } = useI18n();

    return useUpsellModal({
        title: __("Want a better integrated visual content blocker for your website?"),
        testDrive: true,
        feature: "visual-content-blocker",
        assetName: __("pro-modal/visual-content-blocker.webp"),
        description: __(
            "Instead of a lot of text, you can offer your visitor a more pleasant way to view blocked content. For example, you can replace your video embeds with a privacy-compliant dummy player with thumbnail, or an embedded map with a preview map.",
        ),
    });
}

export { useUpsellModalVisualContentBlocker };
