import type { VisualConfiguration } from "@devowl-wp/headless-content-unblocker";
import type { VisualBlocker } from "@devowl-wp/react-cookie-banner";

type FormContentBlockerValueProps = Pick<
    VisualBlocker,
    | "name"
    | "description"
    | "isVisualDarkMode"
    | "services"
    | "visualBlur"
    | "visualContentType"
    | "visualHeroButtonText"
    | "visualThumbnail"
    | "visualType"
> &
    Required<Pick<VisualConfiguration, "isVisual" | "shouldForceToShowVisual">> & {
        status: "draft" | "publish" | "private";
        rules: string;
        criteria: "services" | "tcfVendors";
        tcfVendors: number[];
        tcfPurposes: number[];
        visualDownloadThumbnail: boolean;
        visualMediaThumbnail: number;
        templateCheck: boolean;
        succeessorDeletionCheck: boolean;
    };

type FormContentBlockerServiceTemplateValues = Omit<
    FormContentBlockerValueProps,
    "rules" | "services" | "status" | "templateCheck" | "visualMediaThumbnail"
> & {
    rules: string[];
    serviceTemplates: Array<FormContentBlockerServiceTemplate>;
};

type FormContentBlockerServiceTemplate<Attributes = any> = {
    identifier: string;
    name: string;
    subHeadline: string;
    version: number;
    attributes: Attributes;
    created: number | false;
};

export {
    type FormContentBlockerValueProps,
    type FormContentBlockerServiceTemplateValues,
    type FormContentBlockerServiceTemplate,
};
