import type { VisualService } from "@devowl-wp/react-cookie-banner";

type FormServiceValueProps = Pick<
    VisualService,
    | "name"
    | "uniqueName"
    | "technicalDefinitions"
    | "purpose"
    | "isProviderCurrentWebsite"
    | "provider"
    | "providerContact"
    | "providerPrivacyPolicyUrl"
    | "providerLegalNoticeUrl"
    | "legalBasis"
    | "codeDynamics"
    | "executePriority"
    | "codeOptIn"
    | "executeCodeOptInWhenNoTagManagerConsentIsGiven"
    | "codeOptOut"
    | "executeCodeOptOutWhenNoTagManagerConsentIsGiven"
    | "codeOnPageLoad"
    | "deleteTechnicalDefinitionsAfterOptOut"
    | "isEmbeddingOnlyExternalResources"
    | "dataProcessingInCountries"
    | "dataProcessingInCountriesSpecialTreatments"
    | "googleConsentModeConsentTypes"
    | "tagManagerOptInEventName"
    | "tagManagerOptOutEventName"
> & {
    status: "draft" | "publish" | "private";
    templateCheck: boolean;
    succeessorDeletionCheck: boolean;
    group: number;
    createContentBlocker?: boolean;
    createContentBlockerId?: string;
};

type FormServiceTemplateValues = Omit<FormServiceValueProps, "status" | "templateCheck" | "group"> & {
    /**
     * In a template, the group is not a relation, instead it is the localized group name, e.g. `Essential`.
     */
    group: string;
};

export { type FormServiceValueProps, type FormServiceTemplateValues };
