import type { CookieConsentManagerOptions, ServiceTagManager } from "@devowl-wp/cookie-consent-web-client";
import type { CommonContextProps } from "@devowl-wp/react-cookie-banner";

import type {
    ListMultilingualLanguages,
    ListMultilingualLanguagesRecords,
} from "../components/common/listMultilingualLanguages.js";
import type { useNavLinksPageTypes } from "../hooks/useNavLinksPageTypes.js";
import type { ComponentProps } from "react";

type FormSettingsValuePropsNavItem = Omit<CommonContextProps["links"][0], "url" | "pageType"> & {
    pageType: ReturnType<typeof useNavLinksPageTypes>[number]["name"];
    id?: number;
    isExternalUrl: boolean;
    pageId?: number;
    externalUrl?: string;
    languages?: ListMultilingualLanguagesRecords;
    languageOnClick?: ComponentProps<typeof ListMultilingualLanguages>["onClick"];
};

type FormSettingsValueProps = Pick<
    CommonContextProps,
    | "isDataProcessingInUnsafeCountries"
    | "isAgeNotice"
    | "isListServicesNotice"
    | "isGcmListPurposes"
    | "isTcf"
    | "territorialLegalBasis"
> &
    Pick<CookieConsentManagerOptions, "isGcm" | "failedConsentDocumentationHandling"> & {
        isBannerActive: boolean;
        isBlockerActive: boolean;
        operatorContactAddress: CommonContextProps["websiteOperator"]["address"];
        operatorCountry: CommonContextProps["websiteOperator"]["country"];
        operatorContactPhone: CommonContextProps["websiteOperator"]["contactPhone"];
        operatorContactEmail: CommonContextProps["websiteOperator"]["contactEmail"];
        operatorContactFormId: number;
        cookiePolicyId: number;
        hidePageIds: number[];
        navLinks: FormSettingsValuePropsNavItem[];
        setCookiesViaManager: ServiceTagManager;
        isAcceptAllForBots: boolean;
        isRespectDoNotTrack: boolean;
        isBannerLessConsent: boolean;
        bannerLessConsentShowOnPageIds: number[];
        cookieDuration: number;
        ageNoticeAgeLimit: "INHERIT" | "GDPR" | (string & { h?: string });
        isSaveIp: boolean;
        consentDuration: number;
        isCountryBypass: boolean;
        countryBypassCheckboxTerms: boolean;
        countryBypassCheckboxAccuracy: boolean;
        countryBypassCountries: string[];
        countryBypassType: "all" | "essentials";
        tcfCheckboxTerms: boolean;
        tcfCheckboxVisually: boolean;
        isGcmShowRecommandationsWithoutConsent: boolean;
        isGcmCollectAdditionalDataViaUrlParameters: boolean;
        isGcmRedactAdsDataWithoutConsent: boolean;
        isConsentForwarding: boolean;
        forwardTo: string[];
        crossDomains: string;
        affiliateLink: CommonContextProps["affiliate"]["link"];
        affiliateLabelBehind: CommonContextProps["affiliate"]["labelBehind"];
        affiliateLabelDescription: CommonContextProps["affiliate"]["description"];
    };

export { type FormSettingsValueProps, type FormSettingsValuePropsNavItem };
