# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.1.26 (2026-02-02)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.6.3</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* avoid passing complete zod schemas to ContractResponse (CU-869bdvdfh)</details>





## 1.1.25 (2026-01-23)


### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.8</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.36</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade to TCF 2.3 and support disclosure opt-out, description and special purposes fields (CU-8699gmyb1)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 1.1.24 (2026-01-20)


### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Maintenance

* upgrade to Node 24 (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.16</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.21</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.18</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/api 1.6.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* add HTTP 410 Gone status for deleted reports in order service (CU-8699tgz5g)
* add media upload functionality for logos (CU-8699tgz5g)
* adjust Content-Type handling in fetch client to allow browser to set for FormData (CU-8699tgz5g)
* do not hide internal routes in OpenAPI in non-production environments (CU-8699tgz5g)
* improve developer experience as using schema-mutable methods outside the middleware looses validations and refinements (CU-8699tgz5g)
* prevent duplicate tags in OpenAPI document generation (CU-8699tgz5g)
* review points including 20 (CU-8699tgz5g)
* throw runtime error when refine is used in schema definition (CU-8699tgz5g)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* update refine function parameter naming for consistency across schemas (CU-8699tgz5g)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Documentation

* enhance group management by introducing parent relationships and sorting (CU-8699tgz5g)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.35</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.2</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.13</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* validate vat id syntax for eu and ch (CU-8699tgz5g)


##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.51</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 1.0.16</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>





## 1.1.23 (2026-01-15)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.6.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* refactor new Contract API (CU-8699twn1u)


##### Maintenance

* ai review (CU-8699twn1u)
* fix issues found in testing (CU-8699twn1u)
* fix purpose in contracts ((CU-8699twn1u)
* remove package.json#engines from internal packages (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.34</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* consent handling to use a transport object for better flexibility and add support for 'or' condition in consent checks (CU-f535x6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* in some cases content does not get unblocked when scripts without loading-semantics need to be unblocked first (CU-869brj1eb)


##### Code Refactoring

* consent handling to use a transport object for better flexibility and add support for 'or' condition in consent checks (CU-f535x6)


##### Maintenance

* code AI review (note 7026, CU-f535x6)</details>





## 1.1.22 (2025-12-10)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.33</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* introduce new client-side: content blocker rule syntax (CU-f535x6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.2.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* introduce new client-side: content blocker rule syntax (CU-f535x6)
* prevent iframe location replacement on Firefox Mobile to avoid App-Intent dialog (CU-869be8n2w)


##### Features

* add support for script modules in content blocker (CU-869be7jn7)
* block dynamically injected scripts and stylesheets until consent (CU-f535x6)</details>





## 1.1.21 (2025-12-04)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.5.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* inital implementation of object-storage package (CU-8697h8axv)
* introduce contract profiles with predefined internal profile to exclude from OpenAPI (CU-8699tgz5g)</details>





## 1.1.20 (2025-12-02)


### Bug Fixes

* privacy policy URL in TCF declarations always linked to about:blank (CU-869b2n4v8)


<details><summary>Development dependency update @devowl-wp/api 1.4.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* implement missing file multipart upload in contracts (CU-869badh12)
* implement missing file multipart upload in contracts fetch-client (CU-869badh12)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.21</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* visual confirm.content blocker is shown a second time on click (CU-869b2p070)


##### Performance Improvements

* fix high LCP when using a lot of visual content blockers with confirm() syntax (CU-869b2p070)


##### Tests

* better code coverage with c8 (node-executed code) and v8 (client-side executed code) (CU-f535x6)</details>





## 1.1.19 (2025-11-21)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to set a x-tagGroups via route details (CU-8699tgz5g)
* remove redundant delivery ack policy handling (CU-869am6b3b)


##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 1.1.18 (2025-10-15)


### Bug Fixes

* accessibility for screen reader users (dialog focus, button order, CU-869813z13)


### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.19</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* accessibility for screen reader users (dialog focus, button order, CU-869813z13)</details>

<details><summary>Development dependency update @devowl-wp/api 1.4.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to create literal error code responses (CU-8699tgz5g)
* allow to define routes to be a webhook (CU-8699tgz5g)
* enhance vendor management contracts with new API endpoints and schema updates (CU-8699tgz5g)
* make optional recursion schema properties work as expected (CU-8699tgz5g)


##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


##### Documentation

* user session and magic link routes improved (CU-8699tgz5g)


##### Features

* enhance vendor and user management with new API endpoints and schema updates (CU-8699tgz5g)
* introduce a contract-first design for message brokers with delivery-tuning (CU-869am6b3b)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.2</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade to PNPM@10 (CU-8697je0ta)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 1.1.17 (2025-09-24)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* handle too big device disclosures when using TCF and running into memory issues (CU-8696grpwu)


##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 1.1.16 (2025-09-12)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow v1, v2, ... versioning beside semantic versioning for contract (CU-8699tgz5g)
* remove undefined values from URLSearchParams (CU-869ad2n4f)


##### Documentation

* add another example for multiple nested recursion objects (CU-8699tgz5g)
* uncaught Error: Cannot find module 'node:async_hooks'</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* ui improments and fixed relation machine translation status calculation (CU-8699vyf8j)


##### Code Refactoring

* simple reorg structure discussed and implemented (CU-8699vyf8j)


##### Features

* implement untranslatable management to keep brand names and custom phrases (CU-8699vv1ap)</details>





## 1.1.15 (2025-09-04)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* content length is not always respond by server if using e.g. Cloudflare with Transfer-Encoding: chunked (CU-869ac6g7m)</details>





## 1.1.14 (2025-09-04)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)
* run guard schema validations isolated from complete contract schema validation (CU-8699z5dt7)


##### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)


##### Documentation

* add README for contract-first instroductions (CU-8699z5dt7)


##### Features

* introduce type-safe createFetchClient from all contracts (CU-869a8xjjf)


##### Tests

* add Vitest test runner for our contracts and introduce a first draft for a RPC client type generator (CU-869a8xjjf)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.15</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)


##### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)
* migrate from @devowl-wp/api-request to new fetch client and remove @devowl-wp/api-request (CU-869a8xjjf)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.25</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* deprecated tag manager events are not put into dataLayer when using the GTM4WP service (CU-31mpbvp)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





## 1.1.13 (2025-08-25)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.2.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make API contracts aware of recursion, parameters to object for refinable schema and switch language contexts correctly (CU-8699z5dt7)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.2.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added sl and hr to supported languages (CU-8699ce5ba)</details>





## 1.1.12 (2025-08-08)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.2.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.2.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)</details>





## 1.1.11 (2025-07-29)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.1.10 (2025-07-16)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.1.8</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.12</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)</details>





## 1.1.9 (2025-07-10)


### Bug Fixes

* accessibility issues reported by wpaccessibility.day (CU-869813z13)
* accessibility use aria role button for all buttons in the cookie banner (CU-869813z13)
* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.15</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* accessibility issues reported by wpaccessibility.day (CU-869813z13)
* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.12</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.20</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* allow to make visual content blockers fixed on bottom with confirm(fixed=true) (CU-8699jz5vc)


##### Maintenance

* deprecate Google Tag Manager Event and use Google Consent Mode instead (CU-866ay94xn)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>





## 1.1.8 (2025-06-25)


### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.9</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.14</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.11</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.6</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make contract and entity schemas translatable with i18next (CU-8697uqxnq)


##### Code Refactoring

* introduce contracts for api case study (CU-8697uqxnq)


##### Maintenance

* implement learnings from presentation for API contracts (CU-8697uqxnq)
* started to work on a type-safe client fetch wrapper (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.10</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.9</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.19</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.14</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.6</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.44</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 1.0.9</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>





## 1.1.7 (2025-06-11)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.13</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* custom CSS is not applied for some CSS classes when a visual content blocker is active on the same page (CU-8699cetgq)


##### Maintenance

* enlargement of the minimum content blocker dialog width to 550 px (CU-fb74tf)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.13</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with lazy loaded Google Maps in Voxel theme (CU-86998q97k)</details>





## 1.1.6 (2025-05-15)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.1.5 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.11</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.9</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.4</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.8</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.16</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.11</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.4</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.42</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 1.0.7</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 1.1.4 (2025-05-06)


### Bug Fixes

* remove data-order and order style attributes from consent buttons (CU-8697fw0r4)


### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.10</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* remove data-order and order style attributes from consent buttons (CU-8697fw0r4)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.15</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* update TCF iabtcf-es module to latest version (CU-8698ukcz8)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.10</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Vimeo embeds in Breakdance builder (CU-8698w84ub)</details>





## 1.1.3 (2025-04-25)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.1.2 (2025-04-14)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.8</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* a deduplicated visual content blocker for Elementor videos autoplays all videos after unblock (CU-8698pajgj)</details>





## 1.1.1 (2025-04-08)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





# 1.1.0 (2025-04-02)


### Features

* overwork some texts for Orientierungshilfe der Aufsichtsbehörden 1.2 (CU-86972222q)


### Performance Improvements

* improve LCP count by avoiding a lot of repaints (CU-8698ejjw0)


<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.6</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance Improvements

* improve LCP count by avoiding a lot of repaints (CU-8698ejjw0)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### FEAT

* Service Cloud - Option to enable/disable deactivating all pre-release clients at release (CU-86980gubq)</details>





## 1.0.11 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.6</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.5</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.10</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.6</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.1</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.39</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 1.0.4</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 1.0.10 (2025-03-19)


### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.2</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.9</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* upgrade TCF library to 1.5.15 (CU-86981r4ga)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.5</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Elementor widget CSS and cut visual content blocker headline (CU-8698c7t2b)</details>





## 1.0.9 (2025-03-10)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 1.2.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* add Microsoft Azure to data processing country groups (CU-8697h1a7m)</details>





## 1.0.8 (2025-03-04)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.3</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* corrected calculation full machine translation and introduce flag ignoreOnMachineTranslation (CU-8692xtha4)
* enhance machine translation with granular translation options (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)


##### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.1.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* adding isFullyMachineTranslated to wp client responses (CU-8692xtha4)
* copy only properties on machine translation (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)
* review [#5](https://git.owlinfra.de/devowlio/devowl-wp/issues/5) (CU-2yt6wa5)
* review points from comments (CU-8692xtha4)
* skip known missing glossaries supported by deepl (CU-8692xtha4)


##### Code Refactoring

* introduce field names for template types (CU-8695y66h0)
* reading single service and blocker with translations (CU-8692xtha4)
* rename pre-release client route to plural form (CU-2yt6wa5)


##### Documentation

* add documentation (CU-8692xtha4)


##### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation api WIP (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)
* sync weblate and deepl glossaries for translations (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Bug Fixes

* changed licenses route to use params instead of body data (CU-8695xwj6u)
* license post and patch routes (CU-2yt6wa5)


##### Maintenance

* introduce transactions in controllers (CU-861mfub3j)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>





## 1.0.7 (2025-02-25)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.0.6 (2025-02-24)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.5</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with presto-player (CU-8697zc5r2)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.2</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with presto-player (CU-8697zc5r2)</details>





## 1.0.5 (2025-02-20)


### Bug Fixes

* in GCM mode show link / teach about business.safety.google/privacy (CU-866avf03w)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* add return parameter to the asyn window.consentApi.consent API method (CU-8694x4tnx)


##### Documentation

* improve API docs for consent-checking functions (CU-8694x4tnx)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* correctly block lazy custom web elements by using window.consentApi.unblock API (CU-8697zc5r2)
* make ratio- a ratio CSS class to set the correct height of a blocked element</details>





## 1.0.4 (2025-02-06)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.1.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Elementors optimized markup experimental feature (CU-8697pxjtc)


##### Features

* introduce new selector syntax function jQueryHijackFn to hijack jQuery functions (CU-8697ptyry)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.1.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* requestLanguage added  to controller | find iso 639 language(CU-86971bxhd)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 1.0.3 (2025-01-14)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Styles

* cookie banner language switcher is not responsive (CU-86971prz3)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.0.1</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* delegate click to unblocked nodes after all resources are loaded (CU-gt22gk)</details>





## 1.0.2 (2024-12-06)


### Bug Fixes

* compatibility with darkroomengineering/lenis (CU-8696vxykv)


### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.1</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance Improvements

* use matchesMedia native browser function to check for mobile experience (CU-8696w9pc0)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with ACF Frontend Form for Dynamicooo (CU-8696rw241)</details>





## 1.0.1 (2024-11-11)


### Bug Fixes

* cookie banner with close icon could no longer be replied in List of consents (CU-8696k7mj7)







# 1.0.0 (2024-11-07)


### Bug Fixes

* accessible link with alt text for sticky legal links
* automatically split POMO translations into translatable strings when TranslatePress is active (CU-8696an3mp)
* texts of cooie banner are not editable in TranslatePress edit screen (CU-8696em1me)


### Maintenance

* initial release (CU-869656drt)


### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.0</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 1.0.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 1.0.0</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 1.0.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 1.0.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 1.0.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 1.0.0</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>





## 0.13.4 (2024-10-23)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.7.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* cookie banner separator is always left (CU-8696axtt5)</details>





## 0.13.3 (2024-10-23)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.7.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* visual hero content blocker is not responsive when using a wide width teaching separator (CU-869627051)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.27</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.14.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.4.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.10.3</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* failed to construct 'URL': Invalid URL when using MagnificPopup and WooCommerce Upload Files (CU-8695zwvhy)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.16</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Presto Player not rendering all video embeds (CU-86960tuve)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>





## 0.13.2 (2024-09-27)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 0.7.1</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* name of constents for Bunny.bet and Gcore server locations (CU-8695ybqtp)</details>





## 0.13.1 (2024-09-27)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/iso-codes 0.7.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* server locations of Bunny.net and Gcore (CU-8695ybqtp)</details>





# 0.13.0 (2024-09-26)


### Bug Fixes

* accessibility allow to use escape listener in change/history cookie banner dialog for X-replacement (CU-8695xk0gy)


### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)
* introduce DSG with Trans-Atlantic Data Privacy Framework compatibility (CU-866avtc01)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.7.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* introduce a new option to generate Cookie policy in Cookies > Settings (CU-22wkegu)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.14.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* review points 1-10 without 7 (CU-118mngr)
* review points 4 (CU-118mngr)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* added cdn handling to service templates (CU-118mngr)
* introduce execute priority for services (CU-118mngr)
* new field for services to change the technical handling execute priority (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.4.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Features

* banner-less consent (cookie banner without cookie banner, CU-fb1hvk)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.10.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* compatibility with magnificPopup and YouTube urls covered also by TCF (CU-8695hkk9h)
* unload event listeners are deprecated and will be removed (CU-8695mhu71)


##### Features

* add safety mechanisms for data transmission and option to hide less relevant details (CU-86957nqtx)
* new field for services to change the technical handling execute priority (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.15</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Divi video slider and visual content blockers (CU-8695kgg74)
* do not stop execution when a hijacked jQuery function runs into an error (CU-8695hkk9h)


##### Performance Improvements

* force to render visual content blockers for :confirm() dialogs in idle step (CU-8695xjmf6)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.6.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Features

* data processing countries group Akamai (CU-betuuk)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>





## 0.12.11 (2024-08-28)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* performance tuning and shouldUpdate tweaks (CU-861n9jg7k)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.25</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* apply new eslint rules (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)


##### Code Refactoring

* reordering vars (CU-861n9jg7k)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* fixed es-lint and typings (CU-861n9jg7k)
* hide fields for translator role when empty in default lang (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)
* review 14, hide specific provider fields for translators (CU-861n9jg7k)
* review 3+5, text renames, and display name calculation (CU-861n9jg7k)


##### Code Refactoring

* reordering vars (CU-861n9jg7k)</details>





## 0.12.10 (2024-08-13)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.6</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Styles

* do not show a box shadow for banners in mobile view (CU-86955xtbe)</details>





## 0.12.9 (2024-08-01)


### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.6</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.5</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.3.3</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.11</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* implement a new event RCB/PreDecision/Promises to delay the cookie banner appearance programmatically (CU-86955u6k6)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.13</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>





## 0.12.8 (2024-07-16)


### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)


<details><summary>Development dependency update @devowl-wp/api 0.5.24</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* suppress logs from requests from nullers (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* allow usesNonCookieAccess property in TCF vendor device disclosure (CU-8694xa392)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.10</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy edit dialog (CU-86951yt9g)
* correctly show the accepted TCF and GCM states when using Geo-restriction in privacy settings history (CU-86951yt9g)
* the page cannot be cached (bfcache) because it has a BroadcastChannel instance with registered listeners (CU-86951y06h)</details>





## 0.12.7 (2024-06-20)


### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)
* show correct text in second view (CU-8694vgm6z)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.4</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.3.2</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.23</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.5</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.12</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.9</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.11</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to use confirm() together with visualParent() (CU-2w37t6q)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.5.3</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.33</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 0.2.24</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.12.6 (2024-05-29)


### Bug Fixes

* accessibility elements use prohibited aria attributes aria-labelledby (CU-8694k3zua)
* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.10</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to delegateClick() the real element before opening the hero dialog (confirm(), CU-m15mty)
* do not render visual content blockers in nested confirm() blockers (CU-m15mty)</details>





## 0.12.5 (2024-05-10)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* sticky legal link icon is not aligned correctly when bootstrap is in use (CU-8694dcmep)</details>





## 0.12.4 (2024-04-25)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.21</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introducing password login in rcb (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added moe supported languages (CU-86936my3v)
* disabled default lang edit, hide fields depending on translatable and extended merge strategy plus other fixes (CU-86936my3v)
* enabled statistics with allowedLanguages for translators, changed media permissions (CU-86936my3v)
* filter language select by role parameters (CU-86936my3v)
* introduce lastEditedBy field for templates (CU-86936my3v)
* introduce role parameters to users (CU-86936my3v)
* introducing form field wrapper with role based functionalities and used it for template forms (CU-86936my3v)
* introducing password login in rcb (CU-86936my3v)
* purpose translation variable validation and last editors (CU-86936my3v)
* rename route to user/password (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)
* move password route (CU-86936my3v)</details>





## 0.12.3 (2024-04-23)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.9</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Maintenance

* write NulledVersionUsage deferred (CU-8694939q9)</details>





## 0.12.2 (2024-04-19)


### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* old safari browser shows blurry background and no cookie banner (CU-8694at817)</details>





## 0.12.1 (2024-04-09)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.5</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* cookie banner not shown in older Safari versions (Hotfix, CU-86947y4pv)</details>





# 0.12.0 (2024-04-09)


### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)


### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.6.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce sticky legal links widget in customizer (CU-1za40xb)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* also sync the unblocking of a visual content blocker with other tabs (CU-8693gvgkh)
* introduce a fallback system when the remote server is not available (CU-1xpcvre)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.9</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* window.onload assignment should behave like window load event (CU-86947my22)</details>





## 0.11.1 (2024-03-22)


### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)


<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.3</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* close cookie banner in multi-tab scenario in all tabs (CU-8693gvgkh)</details>





# 0.11.0 (2024-03-13)


### Bug Fixes

* show service group with partial icon when a service with opt-out is configure (CU-86941b3h8)


### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.5.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)


##### Styling

* break all links when viewport gets too small on mobile in second view of cookie banner</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.3.0</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Features

* introduce a new customizer option to define a maximum height for the cookie banner (CU-86940n0a0)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.8</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* allow to avoid visual content blocker deduplication through custom class rcb-avoid-deduplication on parent element (CU-86940a5nt)
* compatibility with GoodLayers page builder and unblocking background videos (CU-8693wxcad)</details>





## 0.10.2 (2024-02-28)


### Bug Fixes

* when changing consent and WordPress is too slow no changes are saved (CU-8693n1cc5)







## 0.10.1 (2024-02-26)


### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.2</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* cookie banner cannot be accepted on old Safari browsers (CU-8693u1wzm)


##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* render shortcodes async and add lazy-require() webpack plugin (CU-8693cqz75)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.4.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Styling

* reset anchor / link styles in cookie banner correctly when theme overwrites it (CU-8693wx9ec)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.2.14</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.1</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* empty template name on release warning message (CU-8693uepwd)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)
* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.7</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Kadence video popups (CU-8693jtbzu)
* initiators for load event should wait also for async scripts (CU-8693wju7t)


##### Performance

* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 0.2.22</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)</details>





# 0.10.0 (2024-02-05)


### Features

* introduce Google Consent Mode (CU-apv5uu)


### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.4.0</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Features

* introduce Google Consent Mode (CU-apv5uu)


##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.9.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Features

* introduce Google Consent Mode (CU-apv5uu)


##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 0.2.21</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Refactoring

* introduce @devowl-wp/react-utils package (CU-8693nj8v6)</details>





## 0.9.10 (2024-01-25)


### Maintenance

* update to antd@5 (CU-863gku332)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.3.9</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.2.13</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* allow updating variables before stylesheet is created (CU-apv5uu)


##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.13.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added successorOfIdentifier field to services and content blocker templates (CU-869372jf7)
* extended client response for services and blocker successorOf (CU-869372jf7)
* introduce ruleNotice to content blockers (CU-86938uzfp)
* removed shouldRemoveTechnicalHandlingWhenOneOf (CU-8693g1maw)
* show a notice for successor templates which replace other templates (CU-869372jf7)


##### Features

* introduce Google Consent Mode (CU-8693g1maw)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.6</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* compatibility with Flatsome UX builder and visual content blockers for video embeds (CU-8693jdhgk)


##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.5.0</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Bug Fixes

* remove unused duplicated translations of country name (CU-866av8d30)


##### Features

* data processing countries group for Automattic (CU-866av8d30)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 0.2.20</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Bug Fixes

* sometimes the recorder registered two clicks with a delay of zero (CU-apv5uu)</details>





## 0.9.9 (2024-01-18)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 0.9.8 (2024-01-08)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.4</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* awin ad within a link is not correctly unblocked, only on reload (CU-8693ff6kr)</details>





## 0.9.7 (2024-01-04)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.7</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Fix

* Admin-UI - Add import/export functionality (CU-86934facb)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.8.4</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* transform also anchor links with GDPR TCF URL parameters (CU-8693cyetg)</details>





## 0.9.6 (2023-12-22)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.6</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* several bugs in release view, introduce release status as calculated field for release view (CU-86936mue3)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.3</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* adsbygoogle.push() error: Fluid responsive ads must be at least 250px wide (CU-8693cxm1p)</details>





## 0.9.5 (2023-12-21)


### Bug Fixes

* list of consents with visual content blockers did no longer work (CU-86939w8af)


### Performance

* do not encode TCModel when initial cookie banner is loaded (CU-8693cf1zr)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>





## 0.9.4 (2023-12-19)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





## 0.9.3 (2023-12-15)


### Bug Fixes

* animation out did no longer work for cookie banner in some cases (CU-869383vck)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.3</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added delete button to media images (CU-8692wfhgk)
* added possibility for release dependency checks WIP (CU-86932dder)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.8.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* when TCF is active, it sometimes requests new consent every day (CU-86939gwcj)


##### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.8.0</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Features

* allow to set required purposes for TCF content blockers (CU-86933edy3)</details>





## 0.9.2 (2023-11-28)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.2</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* allow to show cookie banner also on wp-login.php page when body has class force-cookie-banner (CU-869379120)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>





## 0.9.1 (2023-11-24)


### Bug Fixes

* customizer did not load in some cases (CU-86936qctz)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* uncaught exception in frontend when using PixelYourSite template (CU-86936r76h)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>





# 0.9.0 (2023-11-22)


### Bug Fixes

* accessibility score in PageSpeed Insights for the language switcher in cookie banner (CU-86935zy2c)


### Features

* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)


### Performance

* wait for all suspended components to be mounted and then show cookie banner to avoid CLS (CU-8693572fn)


<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.12.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Documentation

* added description to distinct langs (CU-86934ynxa)


##### Features

* compose GVL v3 and purposes v3 for TCF 2.2 (CU-863gt04va)
* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.7.0</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* when requesting new consent the cookie banner was visible on privacy policy page (CU-869357t9d)


##### Features

* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)</details>





## 0.8.3 (2023-11-16)


### Bug Fixes

* use data-nosnippet to avoid banner texts in SEO snippets (CU-86934vczd)







## 0.8.2 (2023-11-02)


### Bug Fixes

* in some cases the button links are not sticky to the bottom in cookie banner (CU-86931j3bm)


<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.2.7</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Bug Fixes

* in some cases the button links are not sticky to the bottom in cookie banner (CU-86931j3bm)</details>





## 0.8.1 (2023-10-27)


### Bug Fixes

* open cookie banner when initial URL contains #consent-change (CU-8692zqve3)


### Performance

* use dedicated <Suspense component for each lazy loaded component (CU-86930ajxx)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.3.2</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Bug Fixes

* font color on hover does not get changed for buttons in cookie banner (CU-869305hpq)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.13</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Documentation

* update JSDoc, make some methods private and extend some typings (CU-866avtm7z)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.11.5</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Bug Fixes

* added dataProcessingInCountriesSpecialTreatments as extendable attribute (CU-8692z4h5f)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.6.2</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Bug Fixes

* the Google Tag Manager (GTM) receives opt-ins in Data Layer too late (CU-8692xt11g)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>





# 0.8.0 (2023-10-12)


### Bug Fixes

* do not replace minAge and legalBasis variables in cookie banner texts so they work with TranslatePress editor (CU-866awy2fr)


### Features

* introduce age notice age limit (CU-866awy2fr)


### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)


<details><summary>Dependency updates @devowl-wp/web-cookie-banner 0.3.1</summary>


**_Purpose of dependency:_** _Provide a scoped stylesheet, types and util functionality for a web cookie banner._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* prepare upgrade wizard for v4 release (CU-861n7amqx)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>

<details><summary>Dependency updates @devowl-wp/web-scoped-css 0.2.5</summary>


**_Purpose of dependency:_** _Define a scoped stylesheet in JavaScript with performance in mind._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/api-real-cookie-banner 0.11.4</summary>


**_Purpose of dependency:_** _Shared typings for all Real Cookie Banner backend._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/api-real-product-manager 0.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Real Commerce backend._
##### Features

* obtaining telemetry data consent after license activation (CU-861n7amqx)


##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/cookie-consent-web-client 0.6.1</summary>


**_Purpose of dependency:_** _Apply cookies consent (opt-in, opt-out) to the current webpage._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/headless-content-unblocker 0.7.4</summary>


**_Purpose of dependency:_** _Unblock mechanism for @devowl-wp/headless-content-blocker with visual capabilities._
##### Bug Fixes

* do not deduplicate content blocker for confirm selector syntax function (CU-866axjayz)


##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/iso-codes 0.4.5</summary>


**_Purpose of dependency:_** _Enums and key value getters for all countries in different ISO code standards._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/resolve-none-computed-style 1.1.23</summary>


**_Purpose of dependency:_** _Read the actually applied CSS property value instead of the calculated one._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/web-html-element-interaction-recorder 0.2.13</summary>


**_Purpose of dependency:_** _Record and replay interactions on a given HTML element._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>





# 0.7.0 (2023-09-29)


### chore

* review 1 (CU-863h7nj72)
* review 2 (CU-863h7nj72)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)


### feat

* introduce provider contact fields (phone, email, contact form) for services (CU-863h7nj72)
* make links to legal documents more dynamic (CU-cawgkp)
* show a langauge switcher in cookie banner when a multilingual plugin is active (CU-cawgkp)


### fix

* add custom CSS class for cookie banner second layer (CU-866awyqf7)
* add new Is provider current website option for services (CU-863h7nj72)
* show the legal basis in cookie banner with the help of {{legalBasis}} variable (CU-863h7nj72)


### perf

* do not Remove Unused CSS for animate.css to improve PageSpeed CLS when WP Rocket is active (CU-866axeb2m)
* further PageSpeed insights improvements (CU-866avmt9a)
* improve Content Blocker how it affects PageSpeed Insights (CU-866axeb2m)
* improve Content Blocker rendering how it affects PageSpeed Insights (CU-866axeb2m)
* more performant cookie banner rendering by eager lazy loading components (CU-866axeb2m)


### refactor

* rename legalBasis which is applied to the whole cookie banner to territorialLegalBasis (CU-863h7nj72)





## 0.6.4 (2023-09-21)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.6.3 (2023-09-07)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.6.2 (2023-09-06)


### fix

* aria-expanded is applied to a div additionally to the expand-link which is wrong (CU-866avmt9a)


### perf

* improve Google PageSpeed Insights score by using fastdom.mutate (CU-866avmt9a)





## 0.6.1 (2023-08-30)


### fix

* use role button for buttons in cookie banner for better accessibility (CU-861n99y6j)





# 0.6.0 (2023-08-28)


### feat

* introduce accessibility (a11y) notices about contrast ratio for font colors in customizer (CU-863h37kvr)


### fix

* consent links no longer work (CU-866av630d)





# 0.5.0 (2023-08-24)


### feat

* accessible content blocker (CU-863h2xzc9)
* accessible cookie banner (CU-863h2xzc9)
* introduce new confirm() selector-syntax rule for content blockers (CU-861n86a5n)


### fix

* allow multiline text for provider field in service (CU-861myq3qm)
* allow multiline text for provider field in service (CU-861myq3qm)
* do not add dynamic stylesheets to WP Rockets RUCSS optimizaton (CU-2yt81xz)
* flickering effect switching between history and change consent dialog (CU-861n6fudh)
* texts in customizer with non-closing braces leads to visual issues (CU-2gfb4w6)


### refactor

* introduce class names and a scoped stylesheet to Cookie Banner instead of style attribute (CU-2yt81xz)


### style

* mark cookie banner and content blocker with higher CSS specificity (CU-863h2xzc9)





## 0.4.2 (2023-08-02)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.4.1 (2023-07-18)


### fix

* compatibility with Elementor Popups when it gets hidden with click on the content blocker overlay (CU-863h3ah8x)
* introduce special treatments for processing data in unsafe countries (CU-863h6pdwd)





# 0.4.0 (2023-07-06)


### feat

* new feature to collect consent for services processing data in unsecure countries (CU-861m47jgm)


### fix

* huge whitespace on the bottom of the website when scrolling too fast (CU-863h48e1e)





## 0.3.12 (2023-05-30)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.3.11 (2023-05-30)


### perf

* only use getClientBoundingRect when needed (CU-863gucfvx)


### style

* cookie banner overflows to the right when hero content blocker is too wide (CU-861muuzq3)





## 0.3.10 (2023-05-22)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.3.9 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





## 0.3.8 (2023-05-19)


### refactor

* removed flash (CU-863gne88r)





## 0.3.7 (2023-05-15)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.3.6 (2023-05-11)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.3.5 (2023-04-28)


**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.






## 0.3.4 (2023-04-24)


### fix

* cookie banner cannot be opened a second time when opening #consent-change via JavaScript (CU-863ghxhng)





## 0.3.3 (2023-04-19)


### refactor

* introduce taskfile.dev Taskfiles (CU-85zrrymj0)





## 0.3.2 (2023-03-24)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.3.1 (2023-03-21)


### chore

* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)





# 0.3.0 (2023-03-14)


### feat

* new field for service templates "Legal notice URL for provider" (CU-2wpbbhr)





## 0.2.1 (2023-02-21)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.2.0 (2023-02-15)


### feat

* allow to record interactions and introduce player in list of consents (CU-2undj42)
* introduce new individual text field to put text below service groups in second layer (postamble, CU-861mbjkht)


### fix

* show all necessary teachings in content blocker (CU-2wpb5zm)
* show Continue without consent button in Change privacy settings dialog (CU-2x5q7ny)
* title repeated multiple times when emoji is in e.g. YouTube title (CU-863g20zqz)





## 0.1.20 (2023-01-25)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.19 (2023-01-10)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.18 (2023-01-03)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.17 (2022-12-22)


### chore

* update all package.json to resolve release conflicts (CU-382p4kb)





## 0.1.16 (2022-12-12)


### fix

* show notice for invalid TCF device closure within the vendor configuration (CU-37hg97j)
* tcf vendor with not-existing purpose cannot be added to TCF vendor configuration (CU-37hg97j)





## 0.1.15 (2022-12-01)


### style

* use another blur method as it could break absolute positioned menus (CU-3764wqn)





## 0.1.14 (2022-11-24)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.13 (2022-11-18)


### fix

* expand header logo with alt text and correct dimensions for SVG file (CU-33t99y8)





## 0.1.12 (2022-11-15)


### fix

* compatibility with slick menu plugin and cookie banner blurring (CU-2d3czcv)





## 0.1.11 (2022-11-09)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.10 (2022-10-31)


### fix

* blurry cookie banner with Hemmelen theme (CU-32pvebr)





## 0.1.9 (2022-10-25)


### fix

* allow case-insensitive placeholder variables in cookie banner texts (CU-3199wp6)





## 0.1.8 (2022-10-11)


### chore

* introduce consistent type checking for all TypeScript files (CU-2eap113)
* prepare script management for self-hosted Gitlab migrations (CU-2yt2948)
* put gitlab.com URL into environment variables to prepare for self hosted instance (CU-2yt2948)
* remove unused dependencies (CU-3rmk7b)
* switch from yarn to pnpm (CU-3rmk7b)


### fix

* compatibility with ThePlusAddons for Elementor and Offcanvas module (CU-313j37y)
* continue without consent were no longer be disabled when Hide (CU-2znk1f4)
* improved UX when configuring Continue without consent and Save button in customizer (CU-2znk1f4)
* make backend builds compatible with PNPM (CU-3rmk7b)
* show cookie banner on pages selected as Imprint / privacy policy when external page / URL is used (CU-313j6wv)





## 0.1.7 (2022-09-20)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.6 (2022-09-16)


### fix

* blurry body when WP Rocket RUCSS feature is active (CU-2ufpebz)





## 0.1.5 (2022-09-06)

**Note:** This package (@devowl-wp/react-cookie-banner) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.1.4 (2022-08-29)


### chore

* introduce devowl-scripts binary (CU-2n41u7h)
* introduce for non-flat node_modules development experience (CU-2n41u7h)
* introduce new command @devowl-wp/grunt-workspaces/update-local-versions (CU-2n41u7h)
* prepare packages for PNPM isolated module mode (CU-2n41u7h)
* rebase conflicts (CU-2n41u7h)
* show a notice when deactivating animation-in in customizer (CU-2w3br3w)


### fix

* compatibility with Essential Addons for Elementor OffCanvas widget (CU-2je575d)
* compatibility with Groovy Menu plugin (CU-2w8yzk8)
* compatibility with jquery.mmenu and blurred screen when banner active (CU-2v1111h)
* compatibility with latest TCF vendor list and additional information (CU-20r2upf)
* compatibility with Premium Addons for Elementor and Magic Section widget (CU-2v6p47v)


### refactor

* all legal relevant texts put into own context (CU-2uv31dz)
* introduce new admin-UI package to prepare for intuitive service template updates (CU-2d8dedh)
* rename meta field cookies to services (CU-2d8dedh)
* rename meta field noTechnicalDefinitions to isOnlyEmbeddingExternalResources (CU-2d8dedh)
* rename meta field providerPivacyPolicy to providerPrivacyPolicyUrl (CU-2d8dedh)
* rename meta field sessionDuration to isSessionDuration (CU-2d8dedh)
* rename meta field visualDarkMode to isVisualDarkMode (CU-2d8dedh)
* some bundle size savings (CU-20r2upf)





## 0.1.3 (2022-08-09)


### fix

* compatibility with PremiumAddons for Elementor OffCanvas menu (CU-38kmfgj)
* compatibility with WP Mobile Menu plugin and blurred background (CU-2ufpt3q)
* powered by link is print on the bottom page instead of in cookie banner (CU-2phzbpj)


### style

* cookie banner hidden behind header when positioned on top in Divi theme (CU-2r5evnq)
* correct text align for banner buttons when line wraps (CU-2rgx2a0)





## 0.1.2 (2022-07-06)


### style

* line break button if link (CU-2mk1cvt)
* line break button if link (CU-2mk1cvt)





## 0.1.1 (2022-06-08)


### refactor

* extract cookie banner UI to @devowl-wp/react-cookie-banner (CU-2jm1m37)


### style

* text transform uppercase when using Elementor typography (CU-2jzfv15)
