import { useEffect, useState } from "react";

import type { FC } from "react";

const AsciiSpinner: FC<{
    ms?: number;
    /** See https://www.w3schools.com/charsets/ref_utf_geometric.asp */
    chars?: [string, string, string, string];
}> = ({ ms = 100, chars = ["&#9719;", "&#9718;", "&#9717;", "&#9716;"] }) => {
    const [i, setI] = useState(1);

    useEffect(() => {
        const interval = setInterval(() => {
            setI(i + 1);
        }, ms);
        return () => clearInterval(interval);
    }, [i]);

    return <span dangerouslySetInnerHTML={{ __html: chars[i % 4] }} />;
};

export { AsciiSpinner };
