import { Fragment } from "react";

import { findUsedGcmConsentTypes } from "@devowl-wp/cookie-consent-web-client";

import { useBanner } from "../../../contexts/banner.js";
import { useGroupItems } from "../../../hooks/common/useGroupItems.js";
import { GcmConsentType } from "../../common/gcm/consentType.js";
import { Group } from "../../common/groups/group.js";
import { GroupList } from "../../common/groups/groupList.js";
import { BANNER_GROUP_NON_STANDARD_STYLE } from "../body/body.js";

import type { FC } from "react";

const BannerGcmGroupList: FC = () => {
    const banner = useBanner();
    const {
        i18n: {
            purposes,
            gcm: { standard, standardDesc, moreInfo, moreInfoLink },
        },
        designVersion,
    } = banner;
    const allServices = useGroupItems();
    const services = findUsedGcmConsentTypes(allServices);

    return (
        <Fragment>
            <Group headline={standard} style={BANNER_GROUP_NON_STANDARD_STYLE} borderless>
                <div>{standardDesc}</div>
                {designVersion > 10 && (
                    <div style={{ marginTop: 5 }}>
                        {moreInfo}&nbsp;
                        <a href={moreInfoLink} target="_blank" rel="noopener noreferrer">
                            {moreInfoLink}
                        </a>
                    </div>
                )}
            </Group>
            <GroupList>
                <Group headline={purposes}>
                    {services.map((type) => (
                        <GcmConsentType key={type} type={type} isBold />
                    ))}
                </Group>
            </GroupList>
        </Fragment>
    );
};

export { BannerGcmGroupList };
