import { Fragment } from "react";

import { useBanner } from "../../../contexts/banner.js";
import { useGroupCheckbox } from "../../../hooks/common/useGroupCheckbox.js";
import { Checkbox } from "../../common/checkbox.js";

import type { VisualServiceGroup } from "../../../types/service.js";
import type { FC } from "react";

const BannerDottedGroup: FC<{ group: VisualServiceGroup }> = ({ group }) => {
    const { name } = group;
    const banner = useBanner();
    const {
        decision: { groupsFirstView },
        design: { fontSize },
    } = banner;
    const isPro = process.env.PLUGIN_CTX === "pro";

    const showCheckbox = isPro && groupsFirstView;
    const groupCheckbox = useGroupCheckbox(group);

    return (
        <Fragment>
            {showCheckbox ? (
                <Checkbox {...groupCheckbox} fontSize={fontSize}>
                    {name}
                </Checkbox>
            ) : (
                <span>
                    <i></i>
                    <span>{name}</span>
                </span>
            )}
        </Fragment>
    );
};

export { BannerDottedGroup };
