import { extendCommonGroupsStylesheet } from "@devowl-wp/web-cookie-banner";

import { BannerDottedGroup } from "./dottedGroup.js";
import { useBanner } from "../../../contexts/banner.js";
import { useBannerStylesheet } from "../../../hooks/banner/useBannerStylesheet.js";

import type { FC } from "react";

const BannerDottedGroupList: FC = () => {
    const {
        texts: { headline },
    } = useBanner();
    const { DottedGroupList, screenReaderOnlyClass } = useBannerStylesheet().extend(...extendCommonGroupsStylesheet);

    const {
        groups,
        decision: { showGroups },
    } = useBanner();

    return showGroups ? (
        <DottedGroupList>
            <legend className={screenReaderOnlyClass}>{headline}</legend>
            {groups
                .filter(({ items }) => !!items.length)
                .map((group) => (
                    <BannerDottedGroup key={group.id} group={group} />
                ))}
        </DottedGroupList>
    ) : null;
};

export { BannerDottedGroupList };
