import { BannerCookie } from "./cookie.js";
import { useBanner } from "../../../contexts/banner.js";
import { useGroupCheckbox } from "../../../hooks/common/useGroupCheckbox.js";
import { Checkbox } from "../../common/checkbox.js";
import { Group } from "../../common/groups/group.js";
import { LinkToggle } from "../../common/linkToggle.js";

import type { VisualServiceGroup } from "../../../types/service.js";
import type { FC } from "react";

const BannerGroup: FC<{ group: VisualServiceGroup }> = ({ group }) => {
    const banner = useBanner();
    const { name, description, items } = group;
    const {
        group: { headlineFontSize },
        individualTexts: { headline, showMore, hideMore },
    } = banner;

    const groupCheckbox = useGroupCheckbox(group);

    return (
        <Group
            legend={`${headline}: ${name}`}
            headline={
                <Checkbox {...groupCheckbox} fontSize={headlineFontSize}>
                    {name} ({items.length})
                </Checkbox>
            }
        >
            <span>{description}</span>
            {!!items && (
                <LinkToggle showMore={showMore} hideMore={hideMore} bullets groupLabel={name}>
                    {items.map((cookie) => (
                        <BannerCookie key={cookie.id} group={group} cookie={cookie} />
                    ))}
                </LinkToggle>
            )}
        </Group>
    );
};

export { BannerGroup };
